/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.Initializer;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class VerifierMain {
    private static volatile GlassFishRuntime gfr;

    public static void main(String[] args) throws GlassFishException, IOException {
        VerifierFrameworkContext verifierFrameworkContext = new Initializer(args).getVerificationContext();
        VerifierMain.addShutdownHook();
        gfr = GlassFishRuntime.bootstrap();
        GlassFishProperties gfp = new GlassFishProperties();
        gfp.setProperty("__time_zero", new Long(System.currentTimeMillis()).toString());
        String VERIFIER_MODULE = "org.glassfish.verifier";
        gfp.setProperty("hk2.startup.context.mainModule", "org.glassfish.verifier");
        GlassFish gf = gfr.newGlassFish(gfp);
        gf.start();
        int failedCount = -1;
        Verifier verifier = (Verifier)gf.getService(Verifier.class);
        if (verifierFrameworkContext.isUsingGui()) {
            MainFrame mf = new MainFrame(verifierFrameworkContext.getJarFileName(), true, verifier);
            mf.setSize(800, 600);
            mf.setVisible(true);
        } else {
            LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
            try {
                verifier.init(verifierFrameworkContext);
                verifier.verify();
            }
            catch (Exception e) {
                LogRecord logRecord = new LogRecord(Level.SEVERE, smh.getLocalString(verifier.getClass().getName() + ".verifyFailed", "Could not verify successfully."));
                logRecord.setThrown(e);
                verifierFrameworkContext.getResultManager().log(logRecord);
            }
            verifier.generateReports();
            failedCount = verifierFrameworkContext.getResultManager().getFailedCount() + verifierFrameworkContext.getResultManager().getErrorCount();
            System.exit(failedCount);
        }
    }

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("Verifier Shutdown Hook"){

            @Override
            public void run() {
                if (gfr == null) {
                    return;
                }
                try {
                    gfr.shutdown();
                    gfr = null;
                }
                catch (Exception ex) {
                    System.err.println("Error shutting down glassfish runtime: " + ex);
                    ex.printStackTrace();
                }
            }
        });
    }
}

