/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.webservices;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import java.util.Iterator;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.Descriptor;

public class WebServiceCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private final String testsListFileName = "TestNamesWebServices.xml";
    private final String sunONETestsListFileName = WebServiceCheckMgrImpl.getSunPrefix().concat("TestNamesWebServices.xml");
    private String moduleName;

    public WebServiceCheckMgrImpl(VerifierFrameworkContext verifierFrameworkContext) {
        this.verifierFrameworkContext = verifierFrameworkContext;
    }

    @Override
    public void check(Descriptor descriptor) throws Exception {
        WebServicesDescriptor rootDescriptor = (WebServicesDescriptor)descriptor;
        ArchiveType moduleType = rootDescriptor.getBundleDescriptor().getModuleType();
        if (moduleType != null && moduleType.equals((Object)DOLUtils.ejbType())) {
            this.moduleName = "ejb";
        } else if (moduleType != null && moduleType.equals((Object)DOLUtils.warType())) {
            this.moduleName = "web";
        }
        for (WebService wsDescriptor : rootDescriptor.getWebServices()) {
            Iterator endPtItr = wsDescriptor.getEndpoints().iterator();
            while (endPtItr.hasNext()) {
                super.check((Descriptor)((WebServiceEndpoint)endPtItr.next()));
            }
        }
    }

    @Override
    protected String getTestsListFileName() {
        return "TestNamesWebServices.xml";
    }

    @Override
    protected String getSunONETestsListFileName() {
        return this.sunONETestsListFileName;
    }

    @Override
    protected String getSchemaVersion(Descriptor descriptor) {
        return ((WebServiceEndpoint)descriptor).getWebService().getWebServicesDescriptor().getSpecVersion();
    }

    @Override
    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }

    @Override
    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((WebServiceEndpoint)descriptor).getBundleDescriptor();
    }

    @Override
    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((WebServiceEndpoint)descriptor);
    }
}

