/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class ServiceImplBeanLinkCheck
extends WSTest
implements WSCheck {
    public boolean resolveComponentLink(WebServiceEndpoint desc, Result result) {
        boolean resolved = false;
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (desc.implementedByEjbComponent()) {
            EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)desc.getBundleDescriptor();
            if (ejbBundle.hasEjbByName(desc.getEjbLink())) {
                EjbDescriptor ejb = ejbBundle.getEjbByName(desc.getEjbLink());
                if (ejb != null) {
                    resolved = true;
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[{0}] link of service-impl-bean element resolved successfully.", new Object[]{desc.getEjbLink()}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Could not resolve [{0}] link of service-impl-bean element.", new Object[]{desc.getEjbLink()}));
                }
            }
        } else if (desc.implementedByWebComponent()) {
            WebBundleDescriptor webBundle = (WebBundleDescriptor)desc.getBundleDescriptor();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(desc.getWebComponentLink());
            if (webComponent != null && webComponent.isServlet()) {
                resolved = true;
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[{0}] link of service-impl-bean element resolved successfully.", new Object[]{desc.getWebComponentLink()}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Could not resolve [{0}] link of service-impl-bean element.", new Object[]{desc.getWebComponentLink()}));
            }
        }
        return resolved;
    }

    @Override
    public Result check(WebServiceEndpoint wsdescriptor) {
        Result result = this.getInitializedResult();
        boolean pass = this.resolveComponentLink(wsdescriptor, result);
        return result;
    }
}

