/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.util.WebArchiveLoadableHelper;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.web.deployment.descriptor.ErrorPageDescriptor;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;

public class WebArchiveClassesLoadable
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Iterator entries;
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        try {
            entries = this.getClassNames(descriptor).iterator();
        }
        catch (Exception e) {
            result.failed(smh.getLocalString(this.getClass().getName() + ".exception", "Error: [ {0} ] exception while loading the archive [ {1} ].", new Object[]{e, descriptor.getName()}));
            return result;
        }
        boolean allPassed = true;
        ClosureCompiler closureCompiler = this.getVerifierContext().getClosureCompiler();
        ((ClosureCompilerImpl)closureCompiler).addExcludedPattern("org.apache.jasper");
        ((ClosureCompilerImpl)closureCompiler).addExcludedClass("org.apache.catalina.servlets.DefaultServlet");
        if (this.getVerifierContext().isAppserverMode()) {
            ((ClosureCompilerImpl)closureCompiler).addExcludedPattern("com.sun.enterprise");
        }
        while (entries.hasNext()) {
            String className = (String)entries.next();
            boolean status = closureCompiler.buildClosure(className);
            allPassed = status && allPassed;
        }
        if (allPassed) {
            result.setStatus(0);
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the classes are loadable within [ {0} ] without any linkage error.", new Object[]{archiveUri}));
        } else {
            result.setStatus(1);
            this.addErrorDetails(result, compName);
            result.addErrorDetails(WebArchiveLoadableHelper.getFailedResults(closureCompiler, this.getVerifierContext().getOutDir()));
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.loadableError", "Please either bundle the above mentioned classes in the application or use optional packaging support for them."));
        }
        return result;
    }

    private List getClassNames(WebBundleDescriptor descriptor) throws Exception {
        LinkedList<String> results = new LinkedList<String>();
        for (Object obj : descriptor.getServletDescriptors()) {
            String servletClassName = ((WebComponentDescriptor)WebComponentDescriptor.class.cast(obj)).getWebComponentImplementation();
            results.add(servletClassName);
        }
        for (Object obj : descriptor.getServletFilterDescriptors()) {
            String filterClassName = ((ServletFilter)ServletFilter.class.cast(obj)).getClassName();
            results.add(filterClassName);
        }
        for (Object obj : descriptor.getAppListenerDescriptors()) {
            String listenerClassName = ((AppListenerDescriptor)AppListenerDescriptor.class.cast(obj)).getListener();
            results.add(listenerClassName);
        }
        results.addAll(this.getVerifierContext().getFacesConfigDescriptor().getManagedBeanClasses());
        Enumeration en = ((WebBundleDescriptorImpl)descriptor).getErrorPageDescriptors();
        while (en.hasMoreElements()) {
            ErrorPageDescriptor errorPageDescriptor = (ErrorPageDescriptor)en.nextElement();
            String exceptionType = errorPageDescriptor.getExceptionType();
            if (exceptionType == null || exceptionType.equals("")) continue;
            results.add(exceptionType);
        }
        File file = this.getVerifierContext().getOutDir();
        if (!file.exists()) {
            return results;
        }
        FileArchive arch = new FileArchive();
        arch.open(file.toURI());
        Enumeration entries = arch.entries();
        while (entries.hasMoreElements()) {
            String name = (String)entries.nextElement();
            if (!name.startsWith("org/apache/jsp") || !name.endsWith(".class")) continue;
            results.add(name.substring(0, name.lastIndexOf(".")).replace('/', '.'));
        }
        return results;
    }
}

