/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class ASEntBeanName
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String entBeanName = null;
        String ejbName = null;
        try {
            ejbName = descriptor.getName();
            entBeanName = this.getXPathValue("sun-ejb-jar/enterprise-beans/name");
            if (entBeanName == null) {
                result.setStatus(3);
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} Does not define any enterprise bean name", new Object[]{ejbName}));
                return result;
            }
            if (entBeanName != null && entBeanName.length() == 0) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB enterprise-beans] : name should not be empty."));
                return result;
            }
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB enterprise-beans] :  name is {0}", new Object[]{entBeanName}));
            return result;
        }
        catch (Exception ex) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
            return result;
        }
    }
}

