/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceMethodTest;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public abstract class InterfaceMatchMethodException
extends InterfaceMethodTest {
    @Override
    protected boolean runIndividualMethodTest(EjbDescriptor descriptor, Method method, Result result) {
        ComponentNameConstructor compName = null;
        try {
            boolean exceptionsMatch;
            boolean businessMethodFound;
            compName = this.getVerifierContext().getComponentNameConstructor();
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, jcl);
            Class[] methodExceptionTypes = method.getExceptionTypes();
            do {
                Method[] businessMethods = EJBClass.getDeclaredMethods();
                businessMethodFound = false;
                exceptionsMatch = false;
                for (Method businessMethod : businessMethods) {
                    if (!method.getName().equals(businessMethod.getName())) continue;
                    businessMethodFound = true;
                    Class[] businessMethodExceptionTypes = businessMethod.getExceptionTypes();
                    if (!RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(businessMethodExceptionTypes, methodExceptionTypes)) continue;
                    exceptionsMatch = true;
                    break;
                }
                if (businessMethodFound && exceptionsMatch) {
                    this.addGoodDetails(result, compName);
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding business method with matching exceptions was found."));
                    return true;
                }
                if (!businessMethodFound || exceptionsMatch) continue;
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{method.getDeclaringClass().getName(), method.getName()});
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug3", new Object[]{method.getName()});
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug2");
            } while ((EJBClass = EJBClass.getSuperclass()) != null && (!businessMethodFound || !exceptionsMatch));
            if (!exceptionsMatch) {
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding business method with matching exceptions was found for method [ {0} ].", new Object[]{method.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: " + this.getInterfaceType() + "interface [ {0} ] does not " + "exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        return false;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

