/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeInterfaceFindMethodExceptionMatch
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Bean".equals(persistence)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                }
                if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Bean", descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        int ejbFinderMethodLoopCounter = 0;
        try {
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Method[] methods = c.getDeclaredMethods();
            boolean ejbFinderFound = false;
            boolean signaturesMatch = false;
            boolean exceptionsMatch = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("find")) continue;
                ejbFinderFound = false;
                signaturesMatch = false;
                exceptionsMatch = false;
                Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                do {
                    Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                    for (int z = 0; z < ejbFinderMethods.length; ++z) {
                        Object[] ejbFinderMethodParameterTypes;
                        if (!ejbFinderMethods[z].getName().startsWith("ejbFind") || !methods[i].getName().toUpperCase().equals(ejbFinderMethods[z].getName().toUpperCase().substring(3))) continue;
                        ejbFinderFound = true;
                        Object[] methodParameterTypes = methods[i].getParameterTypes();
                        if (!Arrays.equals(methodParameterTypes, ejbFinderMethodParameterTypes = ejbFinderMethods[z].getParameterTypes())) continue;
                        signaturesMatch = true;
                        Class[] methodExceptionTypes = methods[i].getExceptionTypes();
                        Class[] ejbFinderMethodExceptionTypes = ejbFinderMethods[z].getExceptionTypes();
                        if (!RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(ejbFinderMethodExceptionTypes, methodExceptionTypes)) continue;
                        exceptionsMatch = true;
                        ejbFinderMethodLoopCounter = z;
                        break;
                    }
                    if (ejbFinderFound && signaturesMatch && exceptionsMatch) {
                        this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching exceptions was found.", new Object[]{ejbFinderMethods[ejbFinderMethodLoopCounter].getName()}));
                        continue;
                    }
                    if (ejbFinderFound && signaturesMatch && !exceptionsMatch) {
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{c.getName(), methods[i].getName()});
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug3", new Object[]{"ejb" + methods[i].getName().toUpperCase().substring(0, 1) + methods[i].getName().substring(1)});
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug2");
                        continue;
                    }
                    if (!ejbFinderFound || signaturesMatch) continue;
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{c.getName(), methods[i].getName()});
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug4", new Object[]{"ejb" + methods[i].getName().toUpperCase().substring(0, 1) + methods[i].getName().substring(1)});
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug2");
                } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbFinderFound || !signaturesMatch || !exceptionsMatch));
                if (ejbFinderFound || signaturesMatch || exceptionsMatch) continue;
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding [ {0} ] method with matching signatures was found.", new Object[]{"ejb" + methods[i].getName().toUpperCase().substring(0, 1) + methods[i].getName().substring(1)}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or EJB class [ {1} ] does not exist or is not loadable within bean [ {2} ]", new Object[]{home, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

