/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeInterfaceFindByPrimaryKeyName
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean findByPrimaryKeyMethodFound = false;
        boolean oneFailed = false;
        try {
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
            for (int j = 0; j < ejbFinderMethods.length; ++j) {
                if (!ejbFinderMethods[j].getName().equals("findByPrimaryKey")) continue;
                findByPrimaryKeyMethodFound = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "A findByPrimaryKey method was found."));
                return oneFailed;
            }
            if (!findByPrimaryKeyMethodFound) {
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For Home interface [ {0} ] ", new Object[]{homeInterfaceClass.getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No findByPrimaryKey method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{home}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

