/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipFile;

public class ModulesExistEjb
extends ApplicationTest
implements AppCheck {
    @Override
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getBundleDescriptors(EjbBundleDescriptor.class).size() > 0) {
            boolean oneFailed = false;
            for (EjbBundleDescriptor ejbd : descriptor.getBundleDescriptors(EjbBundleDescriptor.class)) {
                if (ejbd.getModuleDescriptor().getArchiveUri().equals("")) continue;
                ZipFile jarFile = null;
                InputStream deploymentEntry = null;
                boolean moduleDirExists = false;
                String archBase = this.getAbstractArchiveUri(descriptor);
                String moduleName = ejbd.getModuleDescriptor().getArchiveUri();
                String moduleDir = FileUtils.makeFriendlyFilename((String)moduleName);
                File f = new File(new File(URI.create(archBase)), moduleDir);
                moduleDirExists = f.isDirectory();
                if (deploymentEntry != null || moduleDirExists) {
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "J2EE EJB module [ {0} ] exists within [ {1} ]", new Object[]{ejbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                } else {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: J2EE EJB module [ {0} ] does not exist within [ {1} ].", new Object[]{ejbd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (deploymentEntry == null) continue;
                    deploymentEntry.close();
                }
                catch (Exception exception) {}
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no EJB components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

