/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public class ComponentNameConstructor {
    private String appName = "";
    private String jarName = "";
    private String componentName = "";

    public ComponentNameConstructor(EjbDescriptor ejbDsc) {
        EjbBundleDescriptor ejbBundle = ejbDsc.getEjbBundleDescriptor();
        ModuleDescriptor moduleDesc = ejbBundle.getModuleDescriptor();
        if (!moduleDesc.isStandalone()) {
            this.appName = ejbBundle.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = ejbDsc.getName();
    }

    public ComponentNameConstructor(BundleDescriptor bundleDesc) {
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if (!moduleDesc.isStandalone()) {
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
    }

    public ComponentNameConstructor(String appName, String jarName, String componentName) {
        this.appName = appName;
        this.jarName = jarName;
        this.componentName = componentName;
    }

    public ComponentNameConstructor(WebServiceEndpoint wse) {
        BundleDescriptor bundleDesc = wse.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if (!moduleDesc.isStandalone()) {
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = wse.getWebService().getName() + "#" + wse.getEndpointName();
    }

    public ComponentNameConstructor(ServiceReferenceDescriptor srd) {
        BundleDescriptor bundleDesc = srd.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if (!moduleDesc.isStandalone()) {
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = srd.getName();
    }

    public ComponentNameConstructor(WebService wsDsc) {
        BundleDescriptor bundleDesc = wsDsc.getBundleDescriptor();
        ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
        if (!moduleDesc.isStandalone()) {
            this.appName = bundleDesc.getApplication().getRegistrationName();
        }
        this.jarName = moduleDesc.getArchiveUri();
        this.componentName = wsDsc.getName();
    }

    public ComponentNameConstructor(Application application) {
        this.appName = application.getRegistrationName();
    }

    public ComponentNameConstructor(PersistenceUnitDescriptor descriptor) {
        PersistenceUnitsDescriptor persistenceUnitsDescriptor = descriptor.getParent();
        RootDeploymentDescriptor container = persistenceUnitsDescriptor.getParent();
        if (container.isApplication()) {
            this.appName = ((Application)Application.class.cast(container)).getRegistrationName();
            this.componentName = persistenceUnitsDescriptor.getPuRoot() + "#" + descriptor.getName();
        } else {
            BundleDescriptor bundleDesc = (BundleDescriptor)BundleDescriptor.class.cast(container);
            ModuleDescriptor moduleDesc = bundleDesc.getModuleDescriptor();
            if (!moduleDesc.isStandalone()) {
                this.appName = bundleDesc.getApplication().getRegistrationName();
            }
            this.jarName = moduleDesc.getArchiveUri();
            String puRoot = persistenceUnitsDescriptor.getPuRoot();
            this.componentName = ("".equals(puRoot) ? "" : puRoot + "#") + descriptor.getName();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!ComponentNameConstructor.isNullOrEmpty(this.appName)) {
            sb.append(this.appName);
        }
        if (!ComponentNameConstructor.isNullOrEmpty(this.jarName)) {
            if (!ComponentNameConstructor.isNullOrEmpty(this.appName)) {
                sb.append("#");
            }
            sb.append(this.jarName);
        }
        if (!ComponentNameConstructor.isNullOrEmpty(this.componentName)) {
            if (!ComponentNameConstructor.isNullOrEmpty(this.jarName) || !ComponentNameConstructor.isNullOrEmpty(this.appName)) {
                sb.append("#");
            }
            sb.append(this.componentName);
        }
        return sb.toString();
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

