/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.io.IOException;
import java.io.InputStream;

public class MappingFileCheck
extends WSClientTest
implements WSClientCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.hasWsdlFile()) {
            if (descriptor.hasMappingFile()) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Mapping file specified because WSDL file is also specified."));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "The webservice client [{0}] has a WSDL file specified but no Mapping File.", new Object[]{compName.toString()}));
            }
        } else if (descriptor.hasMappingFile()) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "The webservice client [{0}] has a Mapping file specified but no WSDL File.", new Object[]{compName.toString()}));
        } else {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Mapping file found at location [{0}] in archive.", new Object[]{descriptor.getMappingFileUri()}));
        }
        if (descriptor.hasMappingFile()) {
            String mappingFile = descriptor.getMappingFileUri();
            InputStream deploymentEntry = null;
            try {
                String uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry(mappingFile);
                if (deploymentEntry == null) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The mapping file does not exist at the specified location [{0}] in the archive.", new Object[]{mappingFile}));
                }
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Mapping file found at location [{0}] in archive.", new Object[]{mappingFile}));
            }
            catch (Exception e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The mapping file does not exist at the specified location [{0}] in the archive.", new Object[]{mappingFile}));
            }
            finally {
                try {
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "This webservice client does not have a Mapping File."));
        }
        return result;
    }
}

