/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.rpc.handler.Handler;

public class HandlerClassCheck
extends WSTest
implements WSCheck {
    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        if (descriptor.hasHandlers()) {
            LinkedList handlers = descriptor.getHandlers();
            Iterator it = handlers.iterator();
            while (it.hasNext()) {
                String hClass = ((WebServiceHandler)it.next()).getHandlerClass();
                Class<?> cl = null;
                try {
                    cl = Class.forName(hClass, false, this.getVerifierContext().getClassLoader());
                    if (cl != null && Handler.class.isAssignableFrom(cl)) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The Handler Class [{0}] exists and implements the javax.xml.rpc.handler.Handler Interface.", new Object[]{hClass}));
                        continue;
                    }
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Handler Class [{0}] does not implement javax.xml.rpc.handler.Handler", new Object[]{hClass}));
                    pass = false;
                }
                catch (ClassNotFoundException e) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.clfailed", "The [{0}] Class [{1}] could not be Loaded", new Object[]{"Handler Class", hClass}));
                }
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not Applicable since No handlers defined in this WebService"));
        }
        return result;
    }
}

