/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASCache;
import org.glassfish.web.deployment.runtime.Cache;
import org.glassfish.web.deployment.runtime.CacheMapping;
import org.glassfish.web.deployment.runtime.ConstraintField;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;

public class ASCacheMappingFieldConstraint
extends ASCache
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        boolean doneAtleastOnce = false;
        try {
            Cache cache = ((SunWebAppImpl)descriptor.getSunDescriptor()).getCache();
            CacheMapping[] cacheMapp = null;
            ConstraintField[] fieldConstraints = null;
            String mappingFor = null;
            if (cache != null) {
                cacheMapp = cache.getCacheMapping();
            }
            if (cache != null && cacheMapp != null && cacheMapp.length != 0) {
                for (int rep = 0; rep < cacheMapp.length; ++rep) {
                    String servletName = cacheMapp[rep].getServletName();
                    String urlPattern = cacheMapp[rep].getURLPattern();
                    mappingFor = servletName != null ? servletName : urlPattern;
                    fieldConstraints = cacheMapp[rep].getConstraintField();
                    if (fieldConstraints == null || fieldConstraints.length == 0) continue;
                    for (int rep1 = 0; rep1 < fieldConstraints.length; ++rep1) {
                        if (fieldConstraints[rep1] == null) continue;
                        doneAtleastOnce = true;
                        if (this.checkFieldConstraint(fieldConstraints[rep1], result, mappingFor, descriptor, compName)) continue;
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB cache-mapping] List of field-constraint in cache-mapping for [ {0} ] is not proper,  within the web archive/(gf/)sun-web.xml of [ {1} ].", new Object[]{mappingFor, descriptor.getName()}));
                    }
                }
            } else {
                notApp = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp || !doneAtleastOnce) {
                result.setStatus(3);
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB cache-mapping ] constraint-field not defined in [ {0} ].", new Object[]{descriptor.getName()}));
            } else {
                result.setStatus(0);
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB cache-mapping] could not create the cache object"));
        }
        return result;
    }

    boolean checkFieldConstraint(ConstraintField fieldCons, Result result, String mappingFor, WebBundleDescriptor descriptor, ComponentNameConstructor compName) {
        boolean valid = true;
        if (fieldCons != null) {
            String fieldName = fieldCons.getAttributeValue("Name");
            String[] values = fieldCons.getValue();
            if (fieldName != null && !fieldName.equals("")) {
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB cache-mapping] Proper field-constraint/fieldName  [ {0} ]  defined for [ {1} ].", new Object[]{fieldName, mappingFor}));
            } else {
                valid = false;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB cache-mapping] field-constraint/fieldName [ {0} ] defined for [ {1} ], attribute can not be empty.", new Object[]{fieldName, mappingFor}));
            }
            for (int rep = 0; values != null && rep < values.length; ++rep) {
                if (values[rep] != null && !values[rep].equals("")) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB cache-mapping]Proper field-constraint/value   [ {0} ]  defined for [ {1} ], within the web archive/(gf/)sun-web.xml of [ {2} ].", new Object[]{values[rep], mappingFor, descriptor.getName()}));
                    continue;
                }
                valid = false;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB cache-mapping] field-constraint/value [ {0} ] defined for [ {1} ], can not be empty, within the web archive/(gf/)sun-web.xml of [ {2} ].", new Object[]{values[rep], mappingFor, descriptor.getName()}));
            }
        }
        return valid;
    }
}

