/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.ejb30.SessionBeanTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class EJBCreatePostConstruct
extends SessionBeanTest {
    @Override
    public Result check(EjbSessionDescriptor descriptor) {
        if (descriptor.isStateless() && descriptor.hasPostConstructMethod() && this.hasEJBCreateMethod(descriptor.getEjbClassName())) {
            for (LifecycleCallbackDescriptor callbackDesc : descriptor.getPostConstructDescriptors()) {
                String cmName = callbackDesc.getLifecycleCallbackMethod();
                if (cmName.contains("ejbCreate")) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Wrong postconstruct method [ {0} ]", new Object[]{cmName}));
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid postcontruct method(s) in Bean"));
        }
        return this.result;
    }

    private boolean hasEJBCreateMethod(String beanClassName) {
        try {
            Method[] methods;
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> bean = Class.forName(beanClassName, false, jcl);
            for (Method method : methods = bean.getMethods()) {
                if (!method.getName().contains("ejbCreate")) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

