/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class AppAltDDWeb
extends ApplicationTest
implements AppCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getBundleDescriptors(WebBundleDescriptor.class).size() > 0) {
            boolean oneFailed = false;
            int na = 0;
            for (WebBundleDescriptor wbd : descriptor.getBundleDescriptors(WebBundleDescriptor.class)) {
                if (wbd.getModuleDescriptor().getAlternateDescriptor() != null) {
                    if (wbd.getModuleDescriptor().getAlternateDescriptor().equals("")) continue;
                    InputStream deploymentEntry = null;
                    try {
                        String uri = this.getAbstractArchiveUri(descriptor);
                        FileArchive arch = new FileArchive();
                        arch.open(uri);
                        deploymentEntry = arch.getEntry(wbd.getModuleDescriptor().getAlternateDescriptor());
                        if (deploymentEntry != null) {
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Found alternate web deployment descriptor URI file [ {0} ] within [ {1} ]", new Object[]{wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No alternate web deployment descriptor URI file found, looking for [{0} ] within [ {1} ]", new Object[]{wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
                        continue;
                    }
                    catch (FileNotFoundException ex) {
                        Verifier.debug(ex);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: File not found trying to read deployment descriptor file [ {0} ] within [ {1} ]", new Object[]{wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
                        continue;
                    }
                    catch (IOException ex) {
                        Verifier.debug(ex);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", " Error: IO Error trying to read deployment descriptor file [ {0} ] within [ {1} ]", new Object[]{wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
                        continue;
                    }
                    finally {
                        try {
                            if (deploymentEntry == null) continue;
                            deploymentEntry.close();
                        }
                        catch (Exception x) {}
                        continue;
                    }
                }
                ++na;
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There is no java web alternative deployment descriptor in [ {0} ]", new Object[]{wbd.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == descriptor.getBundleDescriptors(WebBundleDescriptor.class).size()) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

