/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class BusinessMethodRmiIIOPArgs
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            Set remoteInterfaces = descriptor.getRemoteBusinessClassNames();
            for (String remoteIntf : remoteInterfaces) {
                this.commonToBothInterfaces(remoteIntf, descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Proper declaration of business method(s) found."));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String intf, EjbDescriptor descriptor) {
        try {
            Class<?> intfClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            for (Method remoteMethod : intfClass.getMethods()) {
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                Class<?> beanClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                for (Method method : beanClass.getMethods()) {
                    if (!method.getName().equals(remoteMethod.getName()) || RmiIIOPUtils.isValidRmiIIOPParameters(method.getParameterTypes())) continue;
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: business method [ {0} ] was found, but business method has invalid parameter values. Business method parameter types must be valid types for RMI-IIOP.", new Object[]{method.getName()}));
                }
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{descriptor.getRemoteClassName(), descriptor.getEjbClassName(), descriptor.getName()}));
        }
    }
}

