/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class ApplicationExceptionHomeInterfaceMethods
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getHomeClassName() != null) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the methods of Home interface are defined properly"));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                Class[] methodExceptionTypes = methods.getExceptionTypes();
                if (EjbUtils.isValidApplicationException(methodExceptionTypes)) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "For the Interface [ {0} ] Method [ {1} ] does not throw valid application exceptions", new Object[]{home, methods.getName()}));
            }
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

