/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;

public class TransactionSupportExistence
extends ConnectorTest
implements ConnectorCheck {
    @Override
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        String connectorTransactionSupport = descriptor.getOutboundResourceAdapter().getTransSupport();
        if (connectorTransactionSupport == null) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.nonexist", "Error: No Transaction support specified for ressource adapter", new Object[]{connectorTransactionSupport}));
            return result;
        }
        if (connectorTransactionSupport.equals("NoTransaction")) {
            boolean oneFailed = false;
            if (this.findImplementorOf(descriptor, "javax.resource.spi.LocalTransaction") != null) {
                oneFailed = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(descriptor, "javax.transaction.xa.XAResource") != null) {
                oneFailed = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"NoTransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Transaction support NoTransaction is specified for ressource adapter and [ {0} ] are not implemented", new Object[]{"javax.transaction.xa.XAResource, javax.resource.spi.LocalTransaction"}));
            }
        } else if (connectorTransactionSupport.equals("LocalTransaction")) {
            if (this.findImplementorOf(descriptor, "javax.resource.spi.LocalTransaction") == null) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            } else if (this.findImplementorOf(descriptor, "javax.transaction.xa.XAResource") != null) {
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Transaction support {0} is specified for ressource adapter but [ {1} ] is implemented", new Object[]{"LocalTransaction", "javax.transaction.xa.XAResource"}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"LocalTransaction", "javax.resource.spi.LocalTransaction"}));
            }
        } else if (connectorTransactionSupport.equals("XATransaction")) {
            boolean oneFailed = false;
            if (this.findImplementorOf(descriptor, "javax.resource.spi.LocalTransaction") == null) {
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.resource.spi.LocalTransaction"}));
            }
            if (this.findImplementorOf(descriptor, "javax.transaction.xa.XAResource") == null) {
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: Transaction support {0} is specified for ressource adapter but [ {1} ] is not implemented", new Object[]{"XATransaction", "javax.transaction.xa.XAResource"}));
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Transaction support {0} is specified for ressource adapter and [ {1} ] is(are) implemented", new Object[]{"XATransaction", "javax.transaction.xa.Transaction, javax.resource.spi.LocalTransaction"}));
            }
        } else {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.TransactionSupport.failed", "Error: Deployment descriptor transaction-support [ {0} ] for ressource adapter is not valid", new Object[]{connectorTransactionSupport}));
        }
        return result;
    }
}

