/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.io.IOException;
import java.io.InputStream;

public class MappingFileCheck
extends WSTest
implements WSCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String mappingFile = descriptor.getWebService().getMappingFileUri();
        if (this.getVerifierContext().getSchemaVersion().compareTo("1.1") > 0) {
            if (mappingFile != null) {
                this.addWarningDetails(result, compName);
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "The mapping file as specified in location [ {0} ] is not required.", new Object[]{mappingFile}));
                return result;
            }
        } else {
            InputStream deploymentEntry = null;
            try {
                String uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry(mappingFile);
                if (deploymentEntry == null) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The mapping file does not exist at the specified location [{0}] in the archive.", new Object[]{mappingFile}));
                }
            }
            catch (Exception e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The mapping file does not exist at the specified location [{0}] in the archive.", new Object[]{mappingFile}));
            }
            finally {
                try {
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (result.getStatus() != 1 || result.getStatus() != 2) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "mapping file requirements are satisfied"));
        }
        return result;
    }
}

