/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.TagLibTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.web.FunctionDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class TaglibFunctionMethodTest
extends TagLibTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        Result result = this.getInitializedResult();
        VerifierTestContext context = this.getVerifierContext();
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        FunctionDescriptor[] fnDesc = null;
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            if (tld.getSpecVersion().compareTo("2.0") < 0 || (fnDesc = tld.getFunctionDescriptors()) == null) continue;
            for (FunctionDescriptor fd : fnDesc) {
                this.checkMethodExistence(result, fd, tld, compName);
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All methods defined in the function-signature elementof the tag lib descriptor are properly defined."));
        }
        return result;
    }

    private void checkMethodExistence(Result result, FunctionDescriptor fnDesc, TagLibDescriptor tld, ComponentNameConstructor compName) {
        ClassLoader cl = this.getVerifierContext().getClassLoader();
        String signature = fnDesc.getFunctionSignature();
        String className = fnDesc.getFunctionClass();
        String methodName = this.getName(signature);
        String retType = this.getRetType(signature);
        String[] par = this.getParameters(signature);
        Class[] param = this.getParamTypeClass(par, cl);
        try {
            Method[] methods;
            Class<?> c = Class.forName(className, false, cl);
            boolean passed = false;
            for (Method m : methods = c.getMethods()) {
                if (!m.getName().equals(methodName) || !this.parametersMatch(m, param) || !Modifier.toString(m.getModifiers()).contains("static") || !this.returnTypeMatch(m, retType)) continue;
                passed = true;
                break;
            }
            if (!passed) {
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The method [ {0} ] as defined in function-signatureelement of [ {1} ] does not exists or is not apublic static method in class [ {2} ]", new Object[]{methodName, tld.getUri(), className}));
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }
}

