/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Iterator;
import java.util.Set;

public class ServletInterface
extends WebTest
implements WebCheck {
    final String servletClassPath = "WEB-INF/classes";

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getServletDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean notPassOrFail = true;
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            result = this.loadWarFile(descriptor);
            while (itr.hasNext()) {
                WebComponentDescriptor servlet = (WebComponentDescriptor)itr.next();
                String servletClassName = servlet.getWebComponentImplementation();
                Class c = this.loadClass(result, servletClassName);
                if (c == null) continue;
                if (this.isJAXRPCEndpoint(servlet)) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Not Applicable since, Servlet [ {0} ] is a JAXRPC Endpoint.", new Object[]{servletClassName}));
                    notPassOrFail = false;
                    continue;
                }
                if (ServletInterface.isImplementorOf(c, "javax.servlet.Servlet")) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Servlet class [ {0} ] directly or indirectly implements javax.servlet.Servlet", new Object[]{servletClassName}));
                    notPassOrFail = false;
                    continue;
                }
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Servlet class [ {0} ] does not directly or indirectly implement javax.servlet.Servlet", new Object[]{servletClassName}));
                notPassOrFail = false;
            }
            if (notPassOrFail) {
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Some servlet classes could not be loaded."));
            } else if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlet components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    private boolean isJAXRPCEndpoint(WebComponentDescriptor servlet) {
        WebServicesDescriptor wsdesc;
        String servletClassName = servlet.getWebComponentImplementation();
        if (servletClassName.equals(smh.getLocalString("JAXRPCServlet", "com.sun.xml.rpc.server.http.JAXRPCServlet"))) {
            return true;
        }
        WebBundleDescriptor descriptor = servlet.getWebBundleDescriptor();
        return descriptor.hasWebServices() && (wsdesc = descriptor.getWebServices()).hasEndpointsImplementedBy(servlet);
    }
}

