/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.persistence.AVKPersistenceUnitInfoImpl;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.glassfish.api.deployment.InstrumentableClassLoader;

public class DefaultProviderVerification
extends VerifierTest
implements VerifierCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(Descriptor descriptor) {
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        Result result = this.getInitializedResult();
        result.setStatus(0);
        String appLocation = this.getVerifierContext().getAbstractArchive().getURI().getPath();
        InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(pu.getParent().getClassLoader());
        AVKPersistenceUnitInfoImpl pi = new AVKPersistenceUnitInfoImpl(pu, appLocation, cl);
        this.logger.fine("PersistenceInfo for PU is :\n" + (Object)((Object)pi));
        Properties props = new Properties();
        props.put("eclipselink.validation-only", "TRUE");
        props.put("eclipselink.orm.throw.exceptions", "TRUE");
        props.put("eclipselink.target-server", "SunAS9");
        props.put("eclipselink.weaving", "FALSE");
        PersistenceProvider provider = new PersistenceProvider();
        EntityManagerFactory emf = null;
        try {
            emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, (Map)props);
            this.logger.logp(Level.FINE, "DefaultProviderVerification", "check", "emf = {0}", emf);
        }
        catch (IntegrityException ie) {
            result.setStatus(1);
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            for (Object o : ie.getIntegrityChecker().getCaughtExceptions()) {
                Exception e = (Exception)Exception.class.cast(o);
                result.addErrorDetails(e.getMessage());
            }
        }
        catch (ValidationException ve) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(ve.getMessage());
            this.logger.logp(Level.FINE, "DefaultProviderVerification", "check", "Following exception occurred", ve);
        }
        catch (DatabaseException de) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(de.getMessage());
            this.logger.logp(Level.FINE, "DefaultProviderVerification", "check", "Following exception occurred", de);
        }
        catch (PersistenceException pe) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(pe.getMessage());
            this.logger.logp(Level.FINE, "DefaultProviderVerification", "check", "Following exception occurred", pe);
        }
        finally {
            if (emf != null) {
                emf.close();
            }
        }
        return result;
    }
}

