/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class ASEjbIsReadOnlyBean
extends EjbTest
implements EjbCheck {
    boolean oneFailed = false;
    boolean oneWarning = false;

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            IASEjbExtraDescriptors iasEjbExtraDesc = descriptor.getIASEjbExtraDescriptors();
            String s1 = "/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/is-read-only-bean";
            String isReadOnlyBean = this.getXPathValue(s1);
            if (isReadOnlyBean != null) {
                if (isReadOnlyBean.equals(new String("true"))) {
                    this.testROBSpecific(descriptor, iasEjbExtraDesc, result);
                } else if (isReadOnlyBean.equals(new String("false"))) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB ejb] is-read-only-bean is {0}", new Object[]{new String(isReadOnlyBean)}));
                } else {
                    this.oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB ejb] value [{0}] for is-read-only-bean is incorrect. It can only be true or false", new Object[]{new String(isReadOnlyBean)}));
                }
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ejb] is-read-only-bean Element not defined"));
            }
            if (this.oneFailed) {
                result.setStatus(1);
            } else if (this.oneWarning) {
                result.setStatus(2);
            }
        }
        catch (Exception ex) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
        return result;
    }

    public void testROBSpecific(EjbDescriptor descriptor, IASEjbExtraDescriptors iasEjbExtraDesc, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            int i;
            if (descriptor instanceof EjbEntityDescriptor) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB ejb] : Read Only Beans can only be Entity Beans"));
            } else {
                if (descriptor instanceof EjbSessionDescriptor) {
                    this.oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-EJB ejb] : Read Only Beans cannot be Session Beans. They can only be Entity Beans"));
                    return;
                }
                if (descriptor instanceof EjbMessageBeanDescriptor) {
                    this.oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB ejb] : Read Only Beans cannot be Message Driven Beans. They can only be Entity Beans"));
                    return;
                }
            }
            String txnType = descriptor.getTransactionType();
            if (txnType.equals("Container")) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-EJB ejb] : Read Only Beans can only have Container Managed Transactions"));
            } else {
                this.oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-EJB ejb] : Read Only Beans cannot have Bean Managed Transactions"));
            }
            String homeName = descriptor.getHomeClassName();
            Class<?> homeClass = null;
            boolean foundCreateMethod = false;
            boolean foundRemoveMethod = false;
            homeClass = this.getVerifierContext().getClassLoader().loadClass(homeName);
            Method[] methods = homeClass.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("create")) continue;
                foundCreateMethod = true;
                break;
            }
            for (i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("remove")) continue;
                foundRemoveMethod = true;
                break;
            }
            if (foundCreateMethod) {
                this.oneWarning = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb] : Home interface [ {0} ] should have zero create Methods for Read Only Beans.", new Object[]{homeName}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-EJB ejb] : Read Only Bean has zero create Methods"));
            }
            if (foundRemoveMethod) {
                this.oneWarning = true;
                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning1", "WARNING [AS-EJB ejb] : Home interface [ {0} ] should have zero remove Methods for Read Only Beans.", new Object[]{homeName}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed4", "PASSED [AS-EJB ejb] : Read Only Bean has zero remove Methods"));
            }
            int refreshPeriod = iasEjbExtraDesc.getRefreshPeriodInSeconds();
            if (refreshPeriod != -1) {
                long refValue = new Integer(refreshPeriod).longValue();
                if (refValue < 0L || refValue > Long.MAX_VALUE) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "FAILED [AS-EJB ejb] : refresh-period-in-seconds is invalid. It should be between 0 and {0}.", new Object[]{new Long(Long.MAX_VALUE)}));
                } else {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed5", "PASSED [AS-EJB ejb] : refresh-period-in-seconds is {0}", new Object[]{new Long(refValue)}));
                }
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS-EJB ejb] refresh-period-in-seconds Element not defined"));
            }
            if (this.oneFailed) {
                result.setStatus(1);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.oneFailed = true;
        }
        catch (RuntimeException ex) {
            this.oneFailed = true;
        }
        if (this.oneFailed) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
    }
}

