/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.startup;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service
public class TransactionLifecycleService
implements Startup,
PostConstruct,
PreDestroy {
    @Inject
    Habitat habitat;
    @Inject
    Events events;
    @Inject(optional=true)
    GlassfishNamingManager nm;
    static final String USER_TX_NO_JAVA_COMP = "UserTransaction";
    private static Logger _logger = LogDomains.getLogger(TransactionLifecycleService.class, (String)"javax.enterprise.resource.jta");
    private JavaEETransactionManager tm = null;

    public void postConstruct() {
        EventListener glassfishEventListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (event.is(EventTypes.SERVER_READY)) {
                    _logger.fine("TM LIFECYCLE SERVICE - ON READY");
                    TransactionLifecycleService.this.onReady();
                } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                    _logger.fine("TM LIFECYCLE SERVICE - ON SHUTDOWN");
                    TransactionLifecycleService.this.onShutdown();
                }
            }
        };
        this.events.register(glassfishEventListener);
        if (this.nm != null) {
            try {
                this.nm.publishObject(USER_TX_NO_JAVA_COMP, (Object)new NamingObjectProxy.InitializationNamingObjectProxy(){

                    public Object create(Context ic) throws NamingException {
                        return TransactionLifecycleService.this.habitat.forContract("javax.transaction.UserTransaction").get();
                    }
                }, false);
            }
            catch (NamingException e) {
                _logger.warning("Can't bind \"UserTransaction\" in JNDI");
            }
        }
    }

    public void preDestroy() {
        if (this.nm != null) {
            try {
                this.nm.unpublishObject(USER_TX_NO_JAVA_COMP);
            }
            catch (NamingException e) {
                _logger.warning("Can't unbind \"UserTransaction\" in JNDI");
            }
        }
    }

    public void onReady() {
        boolean isAutomaticRecovery;
        _logger.fine("ON TM READY STARTED");
        TransactionService txnService = (TransactionService)this.habitat.getComponent(TransactionService.class);
        if (txnService != null && (isAutomaticRecovery = Boolean.valueOf(txnService.getAutomaticRecovery()).booleanValue())) {
            _logger.fine("ON TM RECOVERY START");
            this.tm = (JavaEETransactionManager)this.habitat.getByContract(JavaEETransactionManager.class);
            this.tm.initRecovery(false);
            _logger.fine("ON TM RECOVERY END");
        }
        _logger.fine("ON TM READY FINISHED");
    }

    public void onShutdown() {
        Inhabitant inhabitant;
        if (this.tm == null && (inhabitant = this.habitat.getInhabitantByType(JavaEETransactionManager.class)) != null && inhabitant.isActive()) {
            this.tm = (JavaEETransactionManager)inhabitant.get();
        }
        if (this.tm != null) {
            _logger.fine("ON TM SHUTDOWN STARTED");
            this.tm.shutdown();
            _logger.fine("ON TM SHUTDOWN FINISHED");
        }
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

