/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.tests.utils.ConfigApiTest;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public class Utils {
    static final String habitatName = "default";
    static final String inhabitantPath = "META-INF/inhabitants";
    private static Map<String, ServiceLocator> habitats = new HashMap<String, ServiceLocator>();
    public static final Utils instance = new Utils();

    public synchronized ServiceLocator getHabitat(ConfigApiTest test) {
        String fileName = test.getFileName();
        if (habitats.containsKey(fileName)) {
            return habitats.get(fileName);
        }
        ServiceLocator habitat = Utils.getNewHabitat(test);
        habitats.put(fileName, habitat);
        return habitat;
    }

    private static synchronized ServiceLocator getNewHabitat(ConfigApiTest test) {
        ServiceLocator sl = Utils.getNewHabitat();
        String fileName = test.getFileName();
        ConfigParser configParser = new ConfigParser(sl);
        long now = System.currentTimeMillis();
        URL url = Utils.class.getClassLoader().getResource(fileName + ".xml");
        if (url != null) {
            try {
                DomDocument testDocument = test.getDocument(sl);
                DomDocument document = configParser.parse(url, testDocument);
                ServiceLocatorUtilities.addOneConstant((ServiceLocator)sl, (Object)document);
                test.decorate(sl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Logger.getAnonymousLogger().fine("time to parse domain.xml : " + String.valueOf(System.currentTimeMillis() - now));
        }
        return sl;
    }

    public static ServiceLocator getNewHabitat() {
        String root = Utils.class.getResource("/").getPath();
        return Utils.getNewHabitat(root);
    }

    public static ServiceLocator getNewHabitat(String root) {
        Properties p = new Properties();
        p.put("com.sun.aas.installRoot", root);
        p.put("com.sun.aas.instanceRoot", root);
        StaticModulesRegistry registry = new StaticModulesRegistry(Utils.class.getClassLoader(), new StartupContext(p));
        ServiceLocator defaultSL = registry.createServiceLocator(habitatName);
        return defaultSL;
    }

    public void shutdownServiceLocator(ConfigApiTest test) {
        String fileName = test.getFileName();
        if (habitats.containsKey(fileName)) {
            ServiceLocator locator = habitats.remove(fileName);
            ServiceLocatorFactory.getInstance().destroy(locator);
        }
    }
}

