/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

public class ServerUtils {
    public static Queue<Integer> getFreePorts(int count) throws IllegalStateException {
        ArrayDeque<Integer> generatedPorts = new ArrayDeque<Integer>(count);
        HashSet<Integer> excludedPorts = new HashSet<Integer>();
        for (int i = 0; i < count; ++i) {
            int port = ServerUtils.getFreePort(excludedPorts);
            generatedPorts.add(port);
            excludedPorts.add(port);
        }
        return generatedPorts;
    }

    public static int getFreePort() throws IllegalStateException {
        return ServerUtils.getFreePort(Set.of());
    }

    public static int getFreePort(Set<Integer> excluded) throws IllegalStateException {
        int counter = 0;
        while (true) {
            int n;
            ++counter;
            ServerSocket socket = new ServerSocket(0);
            try {
                int port = socket.getLocalPort();
                socket.setSoTimeout(1);
                if (excluded.contains(port) && counter >= 20) {
                    throw new IllegalStateException("Cannot open random port, tried 20 times. Port " + port + " is excluded and we were not able to find another.");
                }
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (counter < 20) continue;
                    throw new IllegalStateException("Cannot open random port, tried 20 times.", e);
                }
            }
            socket.close();
            return n;
            break;
        }
    }

    public static String getLocalIP4Address() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot determine the local address.", e);
        }
    }

    public static File createWar(File warFile, Class<?> ... classes) {
        try {
            WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses((Class[])classes);
            ((ZipExporter)war.as(ZipExporter.class)).exportTo(warFile, true);
            return warFile;
        }
        catch (Exception e) {
            return (File)Assertions.fail((Throwable)e);
        }
    }

    public static String download(URL url) throws IOException {
        Object object = url.getContent();
        if (object instanceof InputStream) {
            try (InputStream input = (InputStream)object;){
                Scanner scanner = new Scanner(input, StandardCharsets.UTF_8);
                try {
                    String string = scanner.nextLine();
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return (String)Assertions.fail((String)("Expected input stream, but received this: " + String.valueOf(object)));
    }

    public static CommandResult runCommand(GlassFish glassfish, String cmd, String params) throws GlassFishException {
        return glassfish.getCommandRunner().run(cmd, new String[]{params});
    }
}

