/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit.matcher;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.jupiter.api.Assertions;

public class TextFileMatchers {
    public static Matcher<File> hasLineCount(long expected, Charset charset) {
        return TextFileMatchers.hasLineCount((Matcher<Long>)CoreMatchers.equalTo((Object)expected), charset);
    }

    public static Matcher<File> hasLineCount(final Matcher<Long> expected, final Charset charset) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public void describeTo(Description description) {
                description.appendText("A file with a number of lines: ").appendDescriptionOf((SelfDescribing)expected);
            }

            protected boolean matchesSafely(File item, Description mismatchDescription) {
                boolean bl;
                LineNumberReader reader = new LineNumberReader(new FileReader(item, charset));
                try {
                    long lineCount = reader.lines().count();
                    boolean result = expected.matches((Object)lineCount);
                    if (!result) {
                        expected.describeMismatch((Object)lineCount, mismatchDescription);
                    }
                    bl = result;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return (Boolean)Assertions.fail((Throwable)e);
                    }
                }
                reader.close();
                return bl;
            }
        };
    }

    public static <T> Matcher<File> getterMatches(final Function<File, T> fileGetter, final Matcher<T> expected) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public void describeTo(Description description) {
                description.appendText("A file getter `").appendValue((Object)fileGetter).appendText("'").appendDescriptionOf((SelfDescribing)expected);
            }

            protected boolean matchesSafely(File item, Description mismatchDescription) {
                Object value = fileGetter.apply(item);
                boolean result = expected.matches(value);
                if (!result) {
                    expected.describeMismatch(value, mismatchDescription);
                }
                return result;
            }
        };
    }
}

