/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.jauth.FailureException;
import com.sun.enterprise.security.jauth.PendingException;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jmac.provider.SOAPAuthParam;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.glassfish.internal.api.Globals;

public class WebServiceSecurity {
    private static Logger _logger = null;
    private static AppServerAuditManager auditManager;
    private static final String SHARED_CLIENT_STATE = "com.sun.enterprise.security.jauth.ClientHashMap";
    private static final String SHARED_SERVER_STATE = "com.sun.enterprise.security.jauth.ServerHashMap";

    public static boolean validateRequest(SOAPMessageContext context, ServerAuthContext sAC) throws AuthException {
        boolean rvalue = true;
        SOAPAuthParam param = new SOAPAuthParam(context.getMessage(), null);
        HashMap sharedState = new HashMap();
        context.setProperty(SHARED_SERVER_STATE, sharedState);
        try {
            rvalue = WebServiceSecurity.validateRequest(param, sharedState, sAC);
        }
        catch (PendingException pe) {
            _logger.log(Level.FINE, "Container-auth: wss: Error validating request  ", pe);
            context.setMessage(param.getResponse());
            rvalue = false;
        }
        catch (FailureException fe) {
            _logger.log(Level.FINE, "Container-auth: wss: Error validating request  ", fe);
            context.setMessage(param.getResponse());
            throw fe;
        }
        return rvalue;
    }

    private static boolean validateRequest(AuthParam param, HashMap sharedState, ServerAuthContext sAC) throws AuthException {
        Set<Principal> principalSet;
        boolean rvalue = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ServerAuthContext.validateRequest");
        }
        Subject subject = null;
        boolean firstAuthentication = true;
        SecurityContext sc = SecurityContext.getCurrent();
        if (sc == null || sc.didServerGenerateCredentials()) {
            subject = new Subject();
        } else {
            subject = sc.getSubject();
            firstAuthentication = false;
        }
        sAC.validateRequest(param, subject, (Map)sharedState);
        if (rvalue && firstAuthentication && (principalSet = subject.getPrincipals()) != null && !principalSet.isEmpty()) {
            String initiator = principalSet.iterator().next().getName();
            SecurityContext newSC = new SecurityContext(initiator, subject);
            SecurityContext.setCurrent((SecurityContext)newSC);
        }
        return rvalue;
    }

    public static void secureResponse(SOAPMessageContext context, ServerAuthContext sAC) throws AuthException {
        WebServiceSecurity.secureResponse(context.getMessage(), (HashMap)context.getProperty(SHARED_SERVER_STATE), sAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void secureResponse(SOAPMessage response, HashMap sharedState, ServerAuthContext sAC) throws AuthException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ServerAuthContext.secureResponse");
        }
        SecurityContext sc = SecurityContext.getCurrent();
        Subject subject = sc.getSubject();
        SOAPAuthParam param = new SOAPAuthParam(null, response);
        try {
            sAC.secureResponse((AuthParam)param, subject, (Map)sharedState);
        }
        finally {
            sAC.disposeSubject(subject, (Map)sharedState);
        }
    }

    public static void secureRequest(SOAPMessageContext context, ClientAuthContext cAC, boolean isAppClient) throws AuthException {
        HashMap<String, Object> sharedState = new HashMap<String, Object>();
        sharedState.put("javax.xml.ws.wsdl.service", context.getProperty("javax.xml.ws.wsdl.service"));
        context.setProperty(SHARED_CLIENT_STATE, sharedState);
        WebServiceSecurity.secureRequest(context.getMessage(), sharedState, cAC, isAppClient);
    }

    private static void secureRequest(SOAPMessage request, HashMap sharedState, ClientAuthContext cAC, boolean isAppClient) throws AuthException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Container Auth: ClientAuthContext.secureRequest");
        }
        SOAPAuthParam param = new SOAPAuthParam(request, null);
        Subject subject = null;
        if (isAppClient) {
            ClientSecurityContext sc = ClientSecurityContext.getCurrent();
            if (sc != null) {
                subject = sc.getSubject();
            }
        } else {
            SecurityContext sc = SecurityContext.getCurrent();
            if (sc != null && !sc.didServerGenerateCredentials()) {
                subject = sc.getSubject();
            }
        }
        if (subject == null) {
            subject = new Subject();
        }
        cAC.secureRequest((AuthParam)param, subject, (Map)sharedState);
    }

    public static boolean validateResponse(SOAPMessageContext context, ClientAuthContext cAC) throws AuthException {
        return WebServiceSecurity.validateResponse(context.getMessage(), (HashMap)context.getProperty(SHARED_CLIENT_STATE), cAC);
    }

    private static boolean validateResponse(SOAPMessage response, HashMap sharedState, ClientAuthContext cAC) throws AuthException {
        boolean rvalue = true;
        Subject responderSubject = new Subject();
        SOAPAuthParam param = new SOAPAuthParam(null, response);
        try {
            cAC.validateResponse((AuthParam)param, responderSubject, (Map)sharedState);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "Container-auth: wss: Error validating response ", ae);
            rvalue = false;
            throw ae;
        }
        finally {
            cAC.disposeSubject(responderSubject, (Map)sharedState);
        }
        return rvalue;
    }

    public static void auditInvocation(SOAPMessageContext context, WebServiceEndpoint endpoint, boolean status) {
        if (auditManager != null && auditManager.isAuditOn()) {
            HttpServletRequest req = (HttpServletRequest)context.getProperty("com.sun.xml.rpc.server.http.HttpServletRequest");
            String uri = null;
            if (req != null) {
                uri = req.getRequestURI();
            }
            String epName = null;
            if (endpoint != null) {
                epName = endpoint.getEndpointName();
            }
            auditManager.webServiceInvocation(uri == null ? "(no uri)" : uri, epName == null ? "(no endpoint)" : epName, status);
        }
    }

    static {
        _logger = LogDomains.getLogger(WebServiceSecurity.class, (String)"javax.enterprise.system.core.security");
        auditManager = null;
        if (Globals.getDefaultHabitat() != null) {
            auditManager = (AppServerAuditManager)Globals.get(AppServerAuditManager.class);
        }
    }
}

