/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.security.web.integration.ConstraintValue;
import com.sun.enterprise.security.web.integration.MapValue;
import com.sun.enterprise.security.web.integration.MethodValue;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.glassfish.security.common.Role;

public class WebPermissionUtil {
    static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static final int PT_DEFAULT = 0;
    private static final int PT_EXTENSION = 1;
    private static final int PT_PREFIX = 2;
    private static final int PT_EXACT = 3;

    static int patternType(Object urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 1;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 2;
        }
        if (pattern.equals("/")) {
            return 0;
        }
        return 3;
    }

    static boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public static HashMap parseConstraints(WebBundleDescriptor wbd) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "parseConstraints");
        }
        Set roleSet = wbd.getRoles();
        HashMap<String, MapValue> qpMap = new HashMap<String, MapValue>();
        qpMap.put("/", new MapValue("/"));
        Enumeration esc = wbd.getSecurityConstraints();
        while (esc.hasMoreElements()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: constraint translation: begin parsing security constraint");
            }
            SecurityConstraint sc = (SecurityConstraint)esc.nextElement();
            AuthorizationConstraint ac = sc.getAuthorizationConstraint();
            UserDataConstraint udc = sc.getUserDataConstraint();
            for (WebResourceCollection wrc : sc.getWebResourceCollections()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint translation: begin parsing web resource collection");
                }
                for (String url : wrc.getUrlPatterns()) {
                    MapValue mValue;
                    if (url != null) {
                        url = url.replaceAll(":", "%3A");
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "JACC: constraint translation: process url: " + url);
                    }
                    if ((mValue = (MapValue)qpMap.get(url)) == null) {
                        mValue = new MapValue(url);
                        for (Map.Entry qpVal : qpMap.entrySet()) {
                            String otherUrl = (String)qpVal.getKey();
                            int otherUrlType = WebPermissionUtil.patternType(otherUrl);
                            switch (WebPermissionUtil.patternType(url)) {
                                case 2: {
                                    if ((otherUrlType == 2 || otherUrlType == 3) && WebPermissionUtil.implies(url, otherUrl)) {
                                        mValue.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType == 2 && WebPermissionUtil.implies(otherUrl, url)) {
                                        ((MapValue)qpVal.getValue()).addQualifier(url);
                                        break;
                                    }
                                    if (otherUrlType != 1 && otherUrlType != 0) break;
                                    ((MapValue)qpVal.getValue()).addQualifier(url);
                                    break;
                                }
                                case 1: {
                                    if (otherUrlType == 2 || otherUrlType == 3 && WebPermissionUtil.implies(url, otherUrl)) {
                                        mValue.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((MapValue)qpVal.getValue()).addQualifier(url);
                                    break;
                                }
                                case 0: {
                                    if (otherUrlType == 0) break;
                                    mValue.addQualifier(otherUrl);
                                    break;
                                }
                                case 3: {
                                    if ((otherUrlType == 2 || otherUrlType == 1) && WebPermissionUtil.implies(otherUrl, url)) {
                                        ((MapValue)qpVal.getValue()).addQualifier(url);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((MapValue)qpVal.getValue()).addQualifier(url);
                                    break;
                                }
                            }
                        }
                        qpMap.put(url, mValue);
                    }
                    String[] methodNames = wrc.getHttpMethodsAsArray();
                    BitSet methods = MethodValue.methodArrayToSet(methodNames);
                    BitSet omittedMethods = null;
                    if (methods.isEmpty()) {
                        String[] omittedNames = wrc.getHttpMethodOmissionsAsArray();
                        omittedMethods = MethodValue.methodArrayToSet(omittedNames);
                    }
                    mValue.setMethodOutcomes(roleSet, ac, udc, methods, omittedMethods);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "JACC: constraint translation: end processing url: " + url);
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: constraint translation: end parsing web resource collection");
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "JACC: constraint translation: end parsing security constraint");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "parseConstraints");
        }
        return qpMap;
    }

    static void handleExcluded(Permissions collection, MapValue m, String name) {
        String actions = null;
        BitSet excludedMethods = m.getExcludedMethods();
        if (m.otherConstraint.isExcluded()) {
            BitSet methods = m.getMethodSet();
            methods.andNot(excludedMethods);
            if (!methods.isEmpty()) {
                actions = "!" + MethodValue.getActions(methods);
            }
        } else if (!excludedMethods.isEmpty()) {
            actions = MethodValue.getActions(excludedMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(name, actions));
        collection.add((Permission)new WebUserDataPermission(name, actions));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: constraint capture: adding excluded methods: " + actions);
        }
    }

    static Permissions addToRoleMap(HashMap<String, Permissions> map, String roleName, Permission p) {
        Permissions collection = map.get(roleName);
        if (collection == null) {
            collection = new Permissions();
            map.put(roleName, collection);
        }
        collection.add(p);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: constraint capture: adding methods to role: " + roleName + " methods: " + p.getActions());
        }
        return collection;
    }

    static void handleRoles(HashMap<String, Permissions> map, MapValue m, String name) {
        BitSet methods;
        HashMap<String, BitSet> rMap = m.getRoleMap();
        List<String> roleList = null;
        if (!m.otherConstraint.isExcluded() && m.otherConstraint.isAuthConstrained()) {
            roleList = m.otherConstraint.roleList;
            for (String roleName : roleList) {
                BitSet methods2 = m.getMethodSet();
                BitSet roleMethods = rMap.get(roleName);
                if (roleMethods != null) {
                    methods2.andNot(roleMethods);
                }
                String actions = null;
                if (!methods2.isEmpty()) {
                    actions = "!" + MethodValue.getActions(methods2);
                }
                WebPermissionUtil.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(name, actions));
            }
        }
        if (!(methods = m.getMethodSet()).isEmpty()) {
            for (Map.Entry<String, BitSet> rval : rMap.entrySet()) {
                BitSet roleMethods;
                String roleName = rval.getKey();
                if (roleList != null && roleList.contains(roleName) || (roleMethods = rval.getValue()).isEmpty()) continue;
                String actions = MethodValue.getActions(roleMethods);
                WebPermissionUtil.addToRoleMap(map, roleName, (Permission)new WebResourcePermission(name, actions));
            }
        }
    }

    static void handleNoAuth(Permissions collection, MapValue m, String name) {
        String actions = null;
        BitSet noAuthMethods = m.getNoAuthMethods();
        if (!m.otherConstraint.isAuthConstrained()) {
            BitSet methods = m.getMethodSet();
            methods.andNot(noAuthMethods);
            if (!methods.isEmpty()) {
                actions = "!" + MethodValue.getActions(methods);
            }
        } else if (!noAuthMethods.isEmpty()) {
            actions = MethodValue.getActions(noAuthMethods);
        } else {
            return;
        }
        collection.add((Permission)new WebResourcePermission(name, actions));
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: constraint capture: adding unchecked (for authorization) methods: " + actions);
        }
    }

    static void handleConnections(Permissions collection, MapValue m, String name) {
        BitSet allConnectMethods = null;
        boolean allConnectAtOther = m.otherConstraint.isConnectAllowed(ConstraintValue.connectTypeNone);
        for (int i = 0; i < ConstraintValue.connectKeys.length; ++i) {
            String actions = null;
            String transport = ConstraintValue.connectKeys[i];
            BitSet connectMethods = m.getConnectMap(1 << i);
            if (i == 0) {
                allConnectMethods = connectMethods;
            } else {
                connectMethods.andNot(allConnectMethods);
            }
            if (m.otherConstraint.isConnectAllowed(1 << i)) {
                if (i != 0 && allConnectAtOther) {
                    if (connectMethods.isEmpty()) continue;
                    actions = MethodValue.getActions(connectMethods);
                } else {
                    BitSet methods = m.getMethodSet();
                    methods.andNot(connectMethods);
                    if (!methods.isEmpty()) {
                        actions = "!" + MethodValue.getActions(methods);
                    }
                }
            } else {
                if (connectMethods.isEmpty()) continue;
                actions = MethodValue.getActions(connectMethods);
            }
            actions = actions == null ? "" : actions;
            String combinedActions = actions + ":" + transport;
            collection.add((Permission)new WebUserDataPermission(name, combinedActions));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "JACC: constraint capture: adding methods that accept connections with protection: " + transport + " methods: " + actions);
        }
    }

    public static void removePolicyStatements(PolicyConfiguration pc, WebBundleDescriptor wbd) throws PolicyContextException {
        pc.removeUncheckedPolicy();
        pc.removeExcludedPolicy();
        Set roleSet = wbd.getRoles();
        for (Role r : roleSet) {
            pc.removeRole(r.getName());
        }
        pc.removeRole("*");
        pc.removeRole("*");
    }

    public static void processConstraints(WebBundleDescriptor wbd, PolicyConfiguration pc) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "processConstraints");
            logger.log(Level.FINE, "JACC: constraint translation: CODEBASE = " + pc.getContextID());
        }
        HashMap qpMap = WebPermissionUtil.parseConstraints(wbd);
        HashMap<String, Permissions> roleMap = new HashMap<String, Permissions>();
        Permissions excluded = new Permissions();
        Permissions unchecked = new Permissions();
        boolean deny = wbd.isDenyUncoveredHttpMethods();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: constraint capture: begin processing qualified url patterns - uncovered http methods will be " + (deny ? "denied" : "permitted"));
        }
        for (MapValue m : qpMap.values()) {
            if (m.irrelevantByQualifier) continue;
            String name = m.urlPatternSpec.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: constraint capture: urlPattern: " + name);
            }
            m.handleUncoveredMethods(deny);
            WebPermissionUtil.handleExcluded(excluded, m, name);
            WebPermissionUtil.handleRoles(roleMap, m, name);
            WebPermissionUtil.handleNoAuth(unchecked, m, name);
            WebPermissionUtil.handleConnections(unchecked, m, name);
        }
        if (logger.isLoggable(Level.FINE)) {
            String ptype;
            Permission p;
            logger.log(Level.FINE, "JACC: constraint capture: end processing qualified url patterns");
            Enumeration<Permission> e = excluded.elements();
            while (e.hasMoreElements()) {
                p = e.nextElement();
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(excluded) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
            e = unchecked.elements();
            while (e.hasMoreElements()) {
                p = e.nextElement();
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(unchecked) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
        pc.addToExcludedPolicy((PermissionCollection)excluded);
        pc.addToUncheckedPolicy((PermissionCollection)unchecked);
        for (Map.Entry rVal : roleMap.entrySet()) {
            String role = (String)rVal.getKey();
            Permissions pCollection = (Permissions)rVal.getValue();
            pc.addToRole(role, (PermissionCollection)pCollection);
            if (!logger.isLoggable(Level.FINE)) continue;
            Enumeration<Permission> e = pCollection.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                String ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(" + role + ") type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "processConstraints");
        }
    }

    public static void createWebRoleRefPermission(WebBundleDescriptor wbd, PolicyConfiguration pc) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "createWebRoleRefPermission");
            logger.log(Level.FINE, "JACC: role-reference translation: Processing WebRoleRefPermission : CODEBASE = " + pc.getContextID());
        }
        ArrayList<Role> role = new ArrayList<Role>();
        Set roleset = wbd.getRoles();
        Role anyAuthUserRole = new Role("**");
        boolean rolesetContainsAnyAuthUserRole = roleset.contains(anyAuthUserRole);
        Set descs = wbd.getWebComponentDescriptors();
        for (WebComponentDescriptor comp : descs) {
            String name = comp.getCanonicalName();
            Enumeration esrr = comp.getSecurityRoleReferences();
            while (esrr.hasMoreElements()) {
                SecurityRoleReference srr = (SecurityRoleReference)esrr.nextElement();
                if (srr == null) continue;
                String action = srr.getRoleName();
                WebRoleRefPermission wrrp = new WebRoleRefPermission(name, action);
                role.add(new Role(action));
                pc.addToRole(srr.getSecurityRoleLink().getName(), (Permission)wrrp);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: role-reference translation: RoleRefPermission created with name(servlet-name)  = " + name + " and action(Role-name tag) = " + action + " added to role(role-link tag) = " + srr.getSecurityRoleLink().getName());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            }
            for (Role r : roleset) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: role-reference translation: Looking at Role =  " + r.getName());
                }
                if (role.contains(r)) continue;
                String action = r.getName();
                WebRoleRefPermission wrrp = new WebRoleRefPermission(name, action);
                pc.addToRole(action, (Permission)wrrp);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: role-reference translation: RoleRef  = " + action + " is added for servlet-resource = " + name);
                logger.log(Level.FINE, "JACC: role-reference translation: Permission added for above role-ref =" + wrrp.getName() + " " + wrrp.getActions());
            }
            if (role.contains(anyAuthUserRole) || rolesetContainsAnyAuthUserRole) continue;
            WebPermissionUtil.addAnyAuthenticatedUserRoleRef(pc, name);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "createWebRoleRefPermission");
        }
        for (Role r : roleset) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: role-reference translation: Looking at Role =  " + r.getName());
            }
            String action = r.getName();
            WebRoleRefPermission wrrp = new WebRoleRefPermission("", action);
            pc.addToRole(action, (Permission)wrrp);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "JACC: role-reference translation: RoleRef  = " + action + " is added for jsp's that can't be mapped to servlets");
            logger.log(Level.FINE, "JACC: role-reference translation: Permission added for above role-ref =" + wrrp.getName() + " " + wrrp.getActions());
        }
        if (!rolesetContainsAnyAuthUserRole) {
            WebPermissionUtil.addAnyAuthenticatedUserRoleRef(pc, "");
        }
    }

    private static void addAnyAuthenticatedUserRoleRef(PolicyConfiguration pc, String name) throws PolicyContextException {
        String action = "**";
        WebRoleRefPermission wrrp = new WebRoleRefPermission(name, action);
        pc.addToRole(action, (Permission)wrrp);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: any authenticated user role-reference translation: Permission added for role-ref =" + wrrp.getName() + " " + wrrp.getActions());
        }
    }
}

