/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import org.glassfish.resources.api.GenericResourceInfo;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.ResourceConflictException;
import org.glassfish.resources.api.ResourceDeployer;
import org.glassfish.resources.api.ResourceDeployerInfo;
import org.glassfish.resources.api.ResourceInfo;
import org.glassfish.resources.api.ResourcePropertyImpl;
import org.glassfish.resources.beans.ExternalJndiResource;
import org.glassfish.resources.naming.JndiProxyObjectFactory;
import org.glassfish.resources.naming.ProxyRefAddr;
import org.glassfish.resources.naming.ResourceNamingService;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.glassfish.resources.util.BindableResourcesHelper;
import org.glassfish.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@ResourceDeployerInfo(value=org.glassfish.resources.config.ExternalJndiResource.class)
@Scoped(value=Singleton.class)
public class ExternalJndiResourceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    private static final StringManager localStrings = StringManager.getManager(ExternalJndiResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(ExternalJndiResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.resources.config.ExternalJndiResource jndiRes = (org.glassfish.resources.config.ExternalJndiResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jndiRes.getJndiName(), applicationName, moduleName);
        this.createExternalJndiResource(jndiRes, resourceInfo);
    }

    public synchronized void deployResource(Object resource) throws Exception {
        org.glassfish.resources.config.ExternalJndiResource jndiRes = (org.glassfish.resources.config.ExternalJndiResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)jndiRes);
        this.createExternalJndiResource(jndiRes, resourceInfo);
    }

    private void createExternalJndiResource(org.glassfish.resources.config.ExternalJndiResource jndiRes, ResourceInfo resourceInfo) {
        if (this.bindableResourcesHelper.isNonConnectorBindableResourceEnabled((BindableResource)jndiRes, resourceInfo)) {
            JavaEEResource j2eeRes = ExternalJndiResourceDeployer.toExternalJndiJavaEEResource(jndiRes, resourceInfo);
            this.installExternalJndiResource((ExternalJndiResource)j2eeRes, resourceInfo);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jndiRes.getJndiName(), "external-jndi-resource"});
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.resources.config.ExternalJndiResource jndiRes = (org.glassfish.resources.config.ExternalJndiResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(jndiRes.getJndiName(), applicationName, moduleName);
        this.deleteResource(jndiRes, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        org.glassfish.resources.config.ExternalJndiResource jndiRes = (org.glassfish.resources.config.ExternalJndiResource)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)jndiRes);
        this.deleteResource(jndiRes, resourceInfo);
    }

    private void deleteResource(org.glassfish.resources.config.ExternalJndiResource jndiResource, ResourceInfo resourceInfo) {
        if (this.bindableResourcesHelper.isNonConnectorBindableResourceEnabled((BindableResource)jndiResource, resourceInfo)) {
            JavaEEResource j2eeResource = ExternalJndiResourceDeployer.toExternalJndiJavaEEResource(jndiResource, resourceInfo);
            this.uninstallExternalJndiResource(j2eeResource, resourceInfo);
        } else {
            _logger.log(Level.FINEST, "core.resource_disabled", new Object[]{jndiResource.getJndiName(), "external-jndi"});
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.resources.config.ExternalJndiResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installExternalJndiResource(ExternalJndiResource extJndiRes, ResourceInfo resourceInfo) {
        try {
            Object factory;
            String factoryClass = extJndiRes.getFactoryClass();
            String jndiLookupName = extJndiRes.getJndiLookupName();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "installExternalJndiResources resourceName " + resourceInfo + " factoryClass " + factoryClass + " jndiLookupName = " + jndiLookupName);
            }
            if ((factory = ResourceUtil.loadObject((String)factoryClass)) == null) {
                _logger.log(Level.WARNING, "jndi.factory_load_error", factoryClass);
                return;
            }
            if (!(factory instanceof InitialContextFactory)) {
                _logger.log(Level.WARNING, "jndi.factory_class_unexpected", factoryClass);
                return;
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            for (ResourceProperty prop : extJndiRes.getProperties()) {
                env.put(prop.getName(), prop.getValue());
            }
            Context context = null;
            try {
                context = ((InitialContextFactory)factory).getInitialContext(env);
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "jndi.initial_context_error", factoryClass);
                _logger.log(Level.SEVERE, "jndi.initial_context_error_excp", ne.getMessage());
            }
            if (context == null) {
                _logger.log(Level.SEVERE, "jndi.factory_create_error", factoryClass);
                return;
            }
            Reference ref = new Reference(extJndiRes.getResType(), "org.glassfish.resources.naming.JndiProxyObjectFactory", null);
            ref.add((RefAddr)new SerializableObjectRefAddr("resourceInfo", (Object)resourceInfo));
            ref.add(new StringRefAddr("jndiLookupName", jndiLookupName));
            ref.add(new StringRefAddr("jndiFactoryClass", factoryClass));
            ref.add((RefAddr)new ProxyRefAddr(extJndiRes.getResourceInfo().getName(), env));
            this.namingService.publishObject(resourceInfo, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error", resourceInfo);
            _logger.log(Level.SEVERE, "customrsrc.create_ref_error_excp", ex);
        }
    }

    public void uninstallExternalJndiResource(JavaEEResource resource, ResourceInfo resourceInfo) {
        block2: {
            JndiProxyObjectFactory.removeInitialContext((ResourceInfo)resource.getResourceInfo());
            try {
                this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, resourceInfo.getName());
            }
            catch (NamingException e) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "Error while unpublishing resource: " + resourceInfo, e);
            }
        }
    }

    public static JavaEEResource toExternalJndiJavaEEResource(org.glassfish.resources.config.ExternalJndiResource rbean, ResourceInfo resourceInfo) {
        ExternalJndiResource jr = new ExternalJndiResource(resourceInfo);
        jr.setEnabled(Boolean.valueOf(rbean.getEnabled()));
        jr.setJndiLookupName(rbean.getJndiLookupName());
        jr.setResType(rbean.getResType());
        jr.setFactoryClass(rbean.getFactoryClass());
        List properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                jr.addProperty((ResourceProperty)rp);
            }
        }
        return jr;
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

