/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.felixwebconsoleextension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultBrandingPlugin;

public class GlassFishBrandingPlugin
implements BrandingPlugin {
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private final String brandName;
    private final String prouctName;
    private final String productImage;
    private final String productUrl;
    private final String vendorName;
    private final String vendorUrl;
    private final String vendorImage;
    private final String favIcon;
    private final String mainStyleSheet;
    private static final String NAME = "GlassFish OSGi Administration Console";
    private static final String PROD_NAME = "GlassFish Server";
    private static final String PROD_IMAGE = "http://java.net/projects/glassfish/sources/svn/content/trunk/main/appserver/osgi-platforms/felix-webconsole-extension/src/main/resources/res/glassfish/logo.png";
    private static final String PROD_URL = "http://GlassFish.org";
    private static final String VENDOR = "GlassFish community";
    private static final String VENDOR_URL = "http://GlassFish.org";
    private static final String VENDOR_IMAGE = "http://java.net/projects/glassfish/sources/svn/content/trunk/main/appserver/osgi-platforms/felix-webconsole-extension/src/main/resources/res/glassfish/logo.png";
    private String path = "/META-INF/webconsole.properties";
    Properties branding = new Properties();

    public GlassFishBrandingPlugin() {
        InputStream inStream = this.getClass().getResourceAsStream(this.path);
        if (inStream != null) {
            try {
                this.branding.load(inStream);
                this.logger.logp(Level.INFO, "GlassFishBrandingPlugin", "GlassFishBrandingPlugin", "branding = {0}", new Object[]{this.branding});
            }
            catch (IOException e) {
                this.logger.logp(Level.INFO, "GlassFishBrandingPlugin", "GlassFishBrandingPlugin", "Failed to read properties file", e);
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.brandName = this.getBranding().getProperty("webconsole.brand.name", NAME);
        this.prouctName = this.getBranding().getProperty("webconsole.product.name", PROD_NAME);
        this.productImage = this.getBranding().getProperty("webconsole.product.image", "http://java.net/projects/glassfish/sources/svn/content/trunk/main/appserver/osgi-platforms/felix-webconsole-extension/src/main/resources/res/glassfish/logo.png");
        this.productUrl = this.getBranding().getProperty("webconsole.product.url", "http://GlassFish.org");
        this.vendorName = this.getBranding().getProperty("webconsole.vendor.name", VENDOR);
        this.vendorUrl = this.getBranding().getProperty("webconsole.vendor.url", "http://GlassFish.org");
        this.vendorImage = this.getBranding().getProperty("webconsole.vendor.image", "http://java.net/projects/glassfish/sources/svn/content/trunk/main/appserver/osgi-platforms/felix-webconsole-extension/src/main/resources/res/glassfish/logo.png");
        this.favIcon = this.getBranding().getProperty("webconsole.favicon", this.getDefaultPlugin().getFavIcon());
        this.mainStyleSheet = this.getBranding().getProperty("webconsole.stylesheet", this.getDefaultPlugin().getMainStyleSheet());
    }

    private DefaultBrandingPlugin getDefaultPlugin() {
        return DefaultBrandingPlugin.getInstance();
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getProductName() {
        return this.prouctName;
    }

    public String getProductURL() {
        return this.productUrl;
    }

    public String getProductImage() {
        return this.productImage;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVendorURL() {
        return this.vendorUrl;
    }

    public String getVendorImage() {
        return this.vendorImage;
    }

    public String getFavIcon() {
        return this.favIcon;
    }

    public String getMainStyleSheet() {
        return this.mainStyleSheet;
    }

    public Properties getBranding() {
        return this.branding;
    }
}

