/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import java.util.Properties;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.reader.api.PropertyReader;
import org.glassfish.loadbalancer.admin.cli.transform.PropertyVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;
import org.glassfish.loadbalancer.config.LbConfig;
import org.jvnet.hk2.config.types.Property;

public class PropertyReaderImpl
implements PropertyReader {
    private String _value = null;
    private String _name = null;
    private String _description = null;

    public static PropertyReader[] getPropertyReaders(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.getProperty("active-healthcheck-enabled") == null) {
            properties.setProperty("active-healthcheck-enabled", "false");
        }
        if (properties.getProperty("number-healthcheck-retries") == null) {
            properties.setProperty("number-healthcheck-retries", "3");
        }
        if (properties.getProperty("rewrite-location") == null) {
            properties.setProperty("rewrite-location", "true");
        }
        if (properties.getProperty("rewrite-cookies") == null) {
            properties.setProperty("rewrite-cookies", "false");
        }
        if (properties.getProperty("response-timeout-in-seconds") == null) {
            properties.setProperty("response-timeout-in-seconds", "60");
        }
        if (properties.getProperty("reload-poll-interval-in-seconds") == null) {
            properties.setProperty("reload-poll-interval-in-seconds", "60");
        }
        if (properties.getProperty("https-routing") == null) {
            properties.setProperty("https-routing", "false");
        }
        if (properties.getProperty("require-monitor-data") == null) {
            properties.setProperty("require-monitor-data", "false");
        }
        if (properties.getProperty("preferred-failover-instance") == null) {
            properties.setProperty("preferred-failover-instance", "true");
        }
        int i = 0;
        int propSize = properties.size();
        PropertyReader[] props = new PropertyReaderImpl[propSize];
        for (String string : properties.keySet()) {
            props[i++] = new PropertyReaderImpl(string, properties.getProperty(string));
        }
        return props;
    }

    public static PropertyReader[] getPropertyReaders(LbConfig _lbConfig) {
        Properties properties = new Properties();
        properties.setProperty("https-routing", _lbConfig.getHttpsRouting());
        properties.setProperty("require-monitor-data", _lbConfig.getMonitoringEnabled());
        properties.setProperty("reload-poll-interval-in-seconds", _lbConfig.getReloadPollIntervalInSeconds());
        properties.setProperty("response-timeout-in-seconds", _lbConfig.getResponseTimeoutInSeconds());
        for (Property property : _lbConfig.getProperty()) {
            if (property.getName().equals("last-applied") || property.getName().equals("last-exported")) continue;
            properties.setProperty(property.getName(), property.getValue());
        }
        return PropertyReaderImpl.getPropertyReaders(properties);
    }

    private PropertyReaderImpl(String name, String value) {
        this._name = name;
        this._value = value;
    }

    public String getName() throws LbReaderException {
        return this._name;
    }

    public String getValue() throws LbReaderException {
        return this._value;
    }

    public String getDescription() throws LbReaderException {
        return this._description;
    }

    public void accept(Visitor v) throws Exception {
        PropertyVisitor pv = (PropertyVisitor)v;
        pv.visit(this);
    }

    private void setValue(LbConfig lbConfig, String name) {
        if (name.equals("response-timeout-in-seconds")) {
            this._value = lbConfig.getResponseTimeoutInSeconds();
        } else if (name.equals("reload-poll-interval-in-seconds")) {
            this._value = lbConfig.getReloadPollIntervalInSeconds();
        }
        this._name = name;
    }
}

