/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-jms-host")
@PerLookup
@I18n(value="create.jms.host")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateJMSHost
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSHost.class);
    @Param(name="mqHost", alias="host", defaultValue="localhost")
    String mqhost;
    @Param(name="mqPort", alias="port", defaultValue="7676")
    String mqport;
    @Param(name="mqUser", alias="adminUserName", defaultValue="admin")
    String mquser;
    @Param(name="mqPassword", alias="adminPassword", defaultValue="admin")
    String mqpassword;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(name="jms_host_name", alias="host", primary=true)
    String jmsHostName;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer;
        ActionReport report = context.getActionReport();
        Config targetConfig = this.domain.getConfigNamed(this.target);
        if (targetConfig != null) {
            this.config = targetConfig;
        }
        if ((targetServer = this.domain.getServerNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        if (this.jmsHostName == null) {
            report.setMessage(localStrings.getLocalString("create.jms.host.noJmsHost", "No JMS Host name specified."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JmsService jmsservice = (JmsService)this.config.getExtensionByType(JmsService.class);
        for (JmsHost jmsHost : jmsservice.getJmsHost()) {
            if (!this.jmsHostName.equals(jmsHost.getName())) continue;
            if (this.force.booleanValue()) {
                ActionReport deleteReport = report.addSubActionsReport();
                ParameterMap parameters = new ParameterMap();
                parameters.set((Object)"DEFAULT", (Object)this.jmsHostName);
                parameters.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-jms-host", deleteReport, context.getSubject()).parameters(parameters).execute();
                if (!ActionReport.ExitCode.FAILURE.equals((Object)deleteReport.getActionExitCode())) break;
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            report.setMessage(localStrings.getLocalString("create.jms.host.duplicate", "A JMS Host named {0} already exists.", new Object[]{this.jmsHostName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                    JmsHost jmsHost = (JmsHost)param.createChild(JmsHost.class);
                    jmsHost.setAdminPassword(CreateJMSHost.this.mqpassword);
                    jmsHost.setAdminUserName(CreateJMSHost.this.mquser);
                    jmsHost.setName(CreateJMSHost.this.jmsHostName);
                    jmsHost.setHost(CreateJMSHost.this.mqhost);
                    jmsHost.setPort(CreateJMSHost.this.mqport);
                    if (CreateJMSHost.this.props != null) {
                        for (Map.Entry<Object, Object> e : CreateJMSHost.this.props.entrySet()) {
                            Property prop = (Property)jmsHost.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            jmsHost.getProperty().add(prop);
                        }
                    }
                    param.getJmsHost().add(jmsHost);
                    return jmsHost;
                }
            }, (ConfigBeanProxy)jmsservice);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.jms.host.fail", "Unable to create jms host {0}.", new Object[]{this.jmsHostName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("create.jms.host.success", "Jms Host {0} created.", new Object[]{this.jmsHostName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

