/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-jmsdest")
@PerLookup
@I18n(value="create.jms.dest")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="create-jmsdest", description="Create JMS Destination", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="create-jmsdest", description="Create JMS Destination", params={@RestParam(name="target", value="$parent")})})
public class CreateJMSDestination
extends JMSDestination
implements AdminCommand {
    static Logger logger = LogDomains.getLogger(CreateJMSDestination.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSDestination.class);
    @Param(name="destType", shortName="T", optional=false)
    String destType;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
        }
        catch (IllegalArgumentException e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.destType.equals("queue")) {
            if (this.props == null) {
                this.props = new Properties();
            }
            if (!this.props.containsKey("maxNumActiveConsumers") && !this.props.containsKey("MaxNumActiveConsumers")) {
                this.props.put("MaxNumActiveConsumers", "-1");
            }
        }
        try {
            this.createJMSDestination(report, context.getSubject());
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.jms.destination.CannotCreateJMSDest", "Unable to create JMS Destination."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJMSDestination(ActionReport report, Subject subject) throws Exception {
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            AttributeList destAttrs = null;
            Object[] params = null;
            if (this.force.booleanValue()) {
                signature = new String[]{};
                params = new Object[]{};
                ObjectName[] dests = (ObjectName[])mbsc.invoke(on, "getDestinations", params, signature);
                boolean destExists = false;
                if (dests != null) {
                    String type = this.destType.equalsIgnoreCase("topic") ? "t" : "q";
                    for (ObjectName dest : dests) {
                        if (dest.toString().indexOf("desttype=" + type + ",name=" + ObjectName.quote(this.destName)) == -1) continue;
                        destExists = true;
                        break;
                    }
                }
                if (destExists) {
                    ActionReport deleteReport = report.addSubActionsReport();
                    ParameterMap parameters = new ParameterMap();
                    parameters.set((Object)"DEFAULT", (Object)this.destName);
                    parameters.set((Object)"destType", (Object)this.destType);
                    parameters.set((Object)"target", (Object)this.target);
                    this.commandRunner.getCommandInvocation("delete-jmsdest", deleteReport, subject).parameters(parameters).execute();
                    if (ActionReport.ExitCode.FAILURE.equals((Object)deleteReport.getActionExitCode())) {
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                }
            }
            if (this.props != null) {
                destAttrs = this.convertProp2Attrs(this.props);
            }
            if (this.destType.equalsIgnoreCase("topic")) {
                this.destType = "t";
            } else if (this.destType.equalsIgnoreCase("queue")) {
                this.destType = "q";
            }
            if (destAttrs == null || destAttrs.size() == 0) {
                signature = new String[]{"java.lang.String", "java.lang.String"};
                params = new Object[]{this.destType, this.destName};
            } else {
                signature = new String[]{"java.lang.String", "java.lang.String", "javax.management.AttributeList"};
                params = new Object[]{this.destType, this.destName, destAttrs};
            }
            mbsc.invoke(on, "create", params, signature);
            report.setMessage(localStrings.getLocalString("create.jms.destination.success", "JMS Desctination {0} created.", new Object[]{this.destName}));
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_creating_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

