/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.ConnectorResource;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-jms-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jms.resource")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.DELETE, path="delete-jms-resource", description="delete-jms-resource")})
public class DeleteJMSResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJMSResource.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("delete.jms.resource.noJndiName", "No JNDI name defined for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport subReport = report.addSubActionsReport();
        ConnectorResource cresource = null;
        Resource res = ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorResource.class, (String)this.jndiName);
        if (res instanceof ConnectorResource) {
            cresource = (ConnectorResource)res;
        }
        if (cresource == null) {
            ParameterMap params = new ParameterMap();
            params.set((Object)"jndi_name", (Object)this.jndiName);
            params.set((Object)"DEFAULT", (Object)this.jndiName);
            params.set((Object)"target", (Object)this.target);
            this.commandRunner.getCommandInvocation("delete-admin-object", subReport).parameters(params).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSAdminObject", "Unable to Delete Admin Object."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        } else {
            String defPoolName = this.jndiName;
            String poolName = cresource.getPoolName();
            if (poolName != null && poolName.equals(defPoolName)) {
                ParameterMap params = new ParameterMap();
                params.set((Object)"DEFAULT", (Object)this.jndiName);
                params.set((Object)"connector_resource_name", (Object)this.jndiName);
                params.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-connector-resource", subReport).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                params = new ParameterMap();
                params.set((Object)"poolname", (Object)this.jndiName);
                params.set((Object)"DEFAULT", (Object)this.jndiName);
                this.commandRunner.getCommandInvocation("delete-connector-connection-pool", subReport).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSPool", "Unable to Delete Connector Connection Pool."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                subReport.setMessage("");
            } else {
                ParameterMap params = new ParameterMap();
                params.set((Object)"DEFAULT", (Object)this.jndiName);
                params.set((Object)"connector_resource_name", (Object)this.jndiName);
                params.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-connector-resource", subReport).parameters(params).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("delete.jms.resource.cannotDeleteJMSResource", "Unable to Delete Connector Resource."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

