/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.pool.monitor;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.resourcebase.resources.api.PoolInfo;

@AMXMetadata(type="jdbc-connection-pool-app-mon", group="monitoring")
@ManagedObject
@Description(value="JDBC Connection pool Application based Statistics")
public class JdbcConnPoolAppStatsProvider {
    private RangeStatisticImpl numConnUsed = new RangeStatisticImpl(0L, 0L, 0L, "NumConnUsed", "count", "Provides connection usage statistics. The total number of connections that are currently being used, as well as information about the maximum number of connections that were used (the high water mark).", System.currentTimeMillis(), System.currentTimeMillis());
    private CountStatisticImpl numConnAcquired = new CountStatisticImpl("NumConnAcquired", "count", "Number of logical connections acquired from the pool.");
    private CountStatisticImpl numConnReleased = new CountStatisticImpl("NumConnReleased", "count", "Number of logical connections released to the pool.");
    private static final String JDBC_APP_PROBE_LISTENER = "glassfish:jdbc-pool:applications:";
    private String appName;
    private String poolName;

    public JdbcConnPoolAppStatsProvider(PoolInfo poolInfo, String appName) {
        this.poolName = poolInfo.getName();
        this.appName = appName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getAppName() {
        return this.appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jdbc-pool:applications:decrementConnectionUsedEvent")
    public void decrementConnectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName) {
        if (poolName != null && poolName.equals(this.poolName) && appName != null && appName.equals(this.appName)) {
            RangeStatisticImpl rangeStatisticImpl = this.numConnUsed;
            synchronized (rangeStatisticImpl) {
                this.numConnUsed.setCurrent(this.numConnUsed.getCurrent() - 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jdbc-pool:applications:connectionUsedEvent")
    public void connectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName) {
        if (poolName != null && poolName.equals(this.poolName) && appName != null && appName.equals(this.appName)) {
            RangeStatisticImpl rangeStatisticImpl = this.numConnUsed;
            synchronized (rangeStatisticImpl) {
                this.numConnUsed.setCurrent(this.numConnUsed.getCurrent() + 1L);
            }
        }
    }

    @ProbeListener(value="glassfish:jdbc-pool:applications:connectionAcquiredEvent")
    public void connectionAcquiredEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName) {
        if (poolName != null && poolName.equals(this.poolName) && appName != null && appName.equals(this.appName)) {
            this.numConnAcquired.increment();
        }
    }

    @ProbeListener(value="glassfish:jdbc-pool:applications:connectionReleasedEvent")
    public void connectionReleasedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="appName") String appName) {
        if (poolName != null && poolName.equals(this.poolName) && appName != null && appName.equals(this.appName)) {
            this.numConnReleased.increment();
        }
    }

    @ManagedAttribute(id="numconnused")
    public RangeStatistic getNumConnUsed() {
        return this.numConnUsed.getStatistic();
    }

    @ManagedAttribute(id="numconnacquired")
    public CountStatistic getNumConnAcquired() {
        return this.numConnAcquired.getStatistic();
    }

    @ManagedAttribute(id="numconnreleased")
    public CountStatistic getNumConnReleased() {
        return this.numConnReleased.getStatistic();
    }
}

