/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.builder.instanceroot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class InstanceRootBuilderUtil {
    private static final Logger logger = Logger.getLogger("embedded-glassfish");
    private static String resourceroot = "glassfish8/glassfish/domains/domain1/";

    public static void buildInstanceRoot(String instanceroot, String configFileURI) throws Exception {
        String resourceName;
        ClassLoader cl = InstanceRootBuilderUtil.class.getClassLoader();
        URL resource = cl.getResource(resourceName = resourceroot);
        URLConnection urlConn = resource.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConn).getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.indexOf(resourceName) == -1 || entryName.endsWith("/")) continue;
                InstanceRootBuilderUtil.copy(cl.getResourceAsStream(entryName), instanceroot, entryName.substring(entryName.indexOf(resourceName) + resourceName.length()));
            }
            jarFile.close();
        }
        if (configFileURI != null) {
            URI configFile = URI.create(configFileURI);
            InstanceRootBuilderUtil.copy(configFile.toURL().openConnection().getInputStream(), instanceroot, "config/domain.xml", true);
        }
    }

    public static void copy(InputStream stream, String destDir, String path) {
        InstanceRootBuilderUtil.copy(stream, destDir, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream stream, String destDir, String path, boolean overwrite) {
        if (stream != null) {
            try {
                File f = new File(destDir, path);
                if (!f.exists() || overwrite) {
                    f.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(new File(destDir, path));
                    byte[] data = new byte[2048];
                    int count = 0;
                    while ((count = stream.read(data)) != -1) {
                        fos.write(data, 0, count);
                    }
                    logger.fine("Created " + String.valueOf(f));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

