/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import jcifs.Config;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import rpc.Security;
import rpc.security.ntlm.AuthenticationSource;
import rpc.security.ntlm.NTLMKeyFactory;
import rpc.security.ntlm.Ntlm1;
import rpc.security.ntlm.Responses;

public class NtlmAuthentication {
    public static final int AUTHENTICATION_SERVICE_NTLM = 10;
    private static final boolean UNICODE_SUPPORTED = Config.getBoolean("jcifs.smb.client.useUnicode", true);
    private static final int BASIC_FLAGS = 0x8202 | (UNICODE_SUPPORTED ? 1 : 0);
    private Security security;
    protected Properties properties;
    private NtlmPasswordAuthentication credentials;
    private AuthenticationSource authenticationSource;
    private boolean lanManagerKey;
    private boolean seal;
    private boolean sign;
    private boolean keyExchange;
    private int keyLength = 40;
    private boolean usentlmv2 = false;
    private static final Random RANDOM = new Random();

    public NtlmAuthentication(Properties properties) {
        this.properties = properties;
        String domain = null;
        String user = null;
        String password = null;
        if (properties != null) {
            this.lanManagerKey = Boolean.valueOf(properties.getProperty("rpc.ntlm.lanManagerKey"));
            this.seal = Boolean.valueOf(properties.getProperty("rpc.ntlm.seal"));
            this.sign = this.seal ? true : Boolean.valueOf(properties.getProperty("rpc.ntlm.sign"));
            this.keyExchange = Boolean.valueOf(properties.getProperty("rpc.ntlm.keyExchange"));
            String keyLength = properties.getProperty("rpc.ntlm.keyLength");
            if (keyLength != null) {
                try {
                    this.keyLength = Integer.parseInt(keyLength);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid key length: " + keyLength);
                }
            }
            this.usentlmv2 = Boolean.valueOf(properties.getProperty("rpc.ntlm.ntlm2"));
            domain = properties.getProperty("rpc.ntlm.domain");
            user = properties.getProperty("rpc.security.username");
            password = properties.getProperty("rpc.security.password");
        }
        this.credentials = new NtlmPasswordAuthentication(domain, user, password);
    }

    public Security getSecurity() throws IOException {
        return this.security;
    }

    protected AuthenticationSource getAuthenticationSource() {
        String sourceClass;
        if (this.authenticationSource != null) {
            return this.authenticationSource;
        }
        String string = sourceClass = this.properties != null ? this.properties.getProperty("rpc.ntlm.authenticationSource") : null;
        if (sourceClass == null) {
            this.authenticationSource = AuthenticationSource.getDefaultInstance();
            return this.authenticationSource;
        }
        try {
            this.authenticationSource = (AuthenticationSource)Class.forName(sourceClass).newInstance();
            return this.authenticationSource;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid authentication source: " + ex);
        }
    }

    private int getDefaultFlags() {
        int flags = BASIC_FLAGS;
        if (this.lanManagerKey) {
            flags |= 0x80;
        }
        if (this.sign) {
            flags |= 0x10;
        }
        if (this.seal) {
            flags |= 0x20;
        }
        if (this.keyExchange) {
            flags |= 0x40000000;
        }
        if (this.keyLength >= 56) {
            flags |= Integer.MIN_VALUE;
        }
        if (this.keyLength >= 128) {
            flags |= 0x20000000;
        }
        if (this.usentlmv2) {
            flags |= 0x80000;
        }
        return flags;
    }

    private int adjustFlags(int flags) {
        if (UNICODE_SUPPORTED && (flags & 1) != 0) {
            flags &= 0xFFFFFFFD;
            flags |= 1;
        } else {
            flags &= 0xFFFFFFFE;
            flags |= 2;
        }
        if (!this.lanManagerKey) {
            flags &= 0xFFFFFF7F;
        }
        if (!this.sign && !this.seal) {
            flags &= 0xFFFFFFEF;
        }
        if (!this.seal) {
            flags &= 0xFFFFFFDF;
        }
        if (!this.keyExchange) {
            flags &= 0xBFFFFFFF;
        }
        if (this.keyLength < 128) {
            flags &= 0xDFFFFFFF;
        }
        if (this.keyLength < 56) {
            flags &= Integer.MAX_VALUE;
        }
        if (!this.usentlmv2) {
            flags &= 0xFFF7FFFF;
        }
        return flags;
    }

    public Type1Message createType1() throws IOException {
        int flags = this.getDefaultFlags();
        return new Type1Message(flags, this.credentials.getDomain(), Type1Message.getDefaultWorkstation());
    }

    public Type2Message createType2(Type1Message type1) throws IOException {
        int flags = type1 == null ? this.getDefaultFlags() : this.adjustFlags(type1.getFlags());
        Type2Message type2Message = new Type2Message(flags |= 0x20000, new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, this.credentials.getDomain());
        return type2Message;
    }

    public Type3Message createType3(Type2Message type2) throws IOException {
        int flags = type2.getFlags();
        if ((flags & 0x40) != 0) {
            flags = this.adjustFlags(flags);
            flags &= 0xFFFDFFFF;
        }
        Type3Message type3 = null;
        if (this.usentlmv2) {
            byte[] ntResponse;
            flags = this.adjustFlags(flags);
            flags &= 0xFFFDFFFF;
            byte[] challenge = type2.getChallenge();
            byte[] lmResponse = new byte[24];
            byte[] clientNonce = new byte[8];
            RANDOM.nextBytes(clientNonce);
            System.arraycopy(clientNonce, 0, lmResponse, 0, clientNonce.length);
            try {
                ntResponse = Responses.getNTLM2SessionResponse(this.credentials.getPassword(), challenge, clientNonce);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security Type3Response", e);
            }
            type3 = new Type3Message(flags, lmResponse, ntResponse, this.credentials.getDomain(), this.credentials.getUsername(), Type3Message.getDefaultWorkstation());
            NTLMKeyFactory ntlmKeyFactory = new NTLMKeyFactory();
            byte[] servernonce = new byte[16];
            System.arraycopy(challenge, 0, servernonce, 0, challenge.length);
            System.arraycopy(clientNonce, 0, servernonce, 8, clientNonce.length);
            try {
                byte[] sessionResponseUserSessionKey = ntlmKeyFactory.getNTLM2SessionResponseUserSessionKey(this.credentials.getPassword(), servernonce);
                byte[] secondayMasterKey = ntlmKeyFactory.getSecondarySessionKey();
                type3.setSessionKey(ntlmKeyFactory.encryptSecondarySessionKey(secondayMasterKey, sessionResponseUserSessionKey));
                this.security = new Ntlm1(flags, secondayMasterKey, false);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security for Type3Response", e);
            }
        }
        byte[] challenge = type2.getChallenge();
        byte[] lmResponse = NtlmPasswordAuthentication.getPreNTLMResponse(this.credentials.getPassword(), challenge);
        byte[] ntResponse = NtlmPasswordAuthentication.getNTLMResponse(this.credentials.getPassword(), challenge);
        type3 = new Type3Message(flags, lmResponse, ntResponse, this.credentials.getDomain(), this.credentials.getUsername(), Type3Message.getDefaultWorkstation());
        if ((flags & 0x40000000) != 0) {
            throw new RuntimeException("Key Exchange not supported by Library !");
        }
        return type3;
    }

    void createSecurityWhenServer(NtlmMessage type3) {
        byte[] sessionResponseUserSessionKey;
        Type3Message type3Message = (Type3Message)type3;
        int flags = type3Message.getFlags();
        NTLMKeyFactory ntlmKeyFactory = new NTLMKeyFactory();
        if (type3Message.getFlag(2048)) {
            sessionResponseUserSessionKey = new byte[16];
        } else {
            byte[] servernonce = new byte[16];
            byte[] challenge = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            System.arraycopy(challenge, 0, servernonce, 0, challenge.length);
            System.arraycopy(type3Message.getLMResponse(), 0, servernonce, 8, 8);
            try {
                sessionResponseUserSessionKey = ntlmKeyFactory.getNTLM2SessionResponseUserSessionKey(this.credentials.getPassword(), servernonce);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occured while forming Session Security from Type3 AUTH", e);
            }
        }
        try {
            byte[] secondayMasterKey = ntlmKeyFactory.decryptSecondarySessionKey(type3Message.getSessionKey(), sessionResponseUserSessionKey);
            this.security = new Ntlm1(flags, secondayMasterKey, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occured while forming Session Security Type3Response", e);
        }
    }
}

