/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.tracing;

import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.component.Inhabitant;

public class TracingUtilities {
    private static final boolean enabled = Boolean.getBoolean("hk2.module.tracestate");
    public static final Node rootNode = new Node(new ExistingSingletonInhabitant<TracingUtilities>(new TracingUtilities()));

    public static boolean isEnabled() {
        return enabled;
    }

    public static void dump(PrintStream ps) {
        for (Node node : new ArrayList<Node>(TracingUtilities.rootNode.children)) {
            node.dump("", ps);
        }
    }

    public static void dump(String typeName, PrintStream ps) {
        TracingUtilities.dump(typeName, rootNode, ps);
    }

    public static void dump(String typeName, Node node, PrintStream ps) {
        for (Node child : new ArrayList<Node>(node.children)) {
            if (child.t.typeName().equals(typeName)) {
                child.dump("", ps);
                return;
            }
            TracingUtilities.dump(typeName, child, ps);
        }
    }

    public static class Node {
        final Inhabitant t;
        final long inception = System.currentTimeMillis();
        long completion;
        final List<Node> children = new ArrayList<Node>();

        public Node(Inhabitant t) {
            this.t = t;
        }

        public void done() {
            this.completion = System.currentTimeMillis();
        }

        public long elapsed() {
            return this.completion - this.inception;
        }

        private void dump(String prefix, PrintStream ps) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < prefix.length(); ++i) {
                buffer.append("|");
            }
            buffer.append("->");
            buffer.append(" Inhabitant : ").append(this.t.typeName()).append(" initialized at ").append(this.inception).append(" took ").append(this.elapsed());
            ps.println(buffer);
            for (Node child : new ArrayList<Node>(this.children)) {
                child.dump(prefix + "  ", ps);
            }
        }
    }
}

