/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util.privilegedactions;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import javax.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetAnnotationParameter<T>
implements PrivilegedAction<T> {
    private final Annotation annotation;
    private final String parameterName;
    private final Class<T> type;

    public static <T> GetAnnotationParameter<T> action(Annotation annotation, String parameterName, Class<T> type2) {
        return new GetAnnotationParameter<T>(annotation, parameterName, type2);
    }

    private GetAnnotationParameter(Annotation annotation, String parameterName, Class<T> type2) {
        this.annotation = annotation;
        this.parameterName = parameterName;
        this.type = type2;
    }

    @Override
    public T run() {
        try {
            Method m = this.annotation.getClass().getMethod(this.parameterName, new Class[0]);
            m.setAccessible(true);
            Object o = m.invoke((Object)this.annotation, new Object[0]);
            if (o.getClass().getName().equals(this.type.getName())) {
                return (T)o;
            }
            String msg = "Wrong parameter type. Expected: " + this.type.getName() + " Actual: " + o.getClass().getName();
            throw new ValidationException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "The specified annotation defines no parameter '" + this.parameterName + "'.";
            throw new ValidationException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to get '" + this.parameterName + "' from " + this.annotation.getClass().getName();
            throw new ValidationException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "Unable to get '" + this.parameterName + "' from " + this.annotation.getClass().getName();
            throw new ValidationException(msg, e);
        }
    }
}

