/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.reader.impl;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.reader.api.InstanceReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.LbReaderException;
import org.glassfish.loadbalancer.admin.cli.transform.InstanceVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;

public class InstanceReaderImpl
implements InstanceReader {
    private Domain _domain = null;
    private ServerRef _serverRef = null;
    private Server _server = null;
    private static final String HTTP_PROTO = "http://";
    private static final String HTTPS_PROTO = "https://";
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final String BIND_TO_ANY = "0.0.0.0";
    private static final String LOCALHOST = "localhost";

    public InstanceReaderImpl(Domain domain, ServerRef ref) {
        this._domain = domain;
        this._serverRef = ref;
        this._server = domain.getServerNamed(ref.getRef());
    }

    public InstanceReaderImpl(Domain domain, Server server) {
        this._domain = domain;
        this._server = server;
    }

    public String getName() throws LbReaderException {
        return this._server.getName();
    }

    public boolean getLbEnabled() throws LbReaderException {
        if (this._serverRef != null) {
            return Boolean.valueOf(this._serverRef.getLbEnabled());
        }
        return true;
    }

    public String getDisableTimeoutInMinutes() throws LbReaderException {
        if (this._serverRef != null) {
            return this._serverRef.getDisableTimeoutInMinutes();
        }
        return "30";
    }

    public String getWeight() throws LbReaderException {
        return this._server.getLbWeight();
    }

    public String getListeners() throws LbReaderException {
        StringBuffer listenerStr = new StringBuffer();
        Config config = this._domain.getConfigNamed(this._server.getConfigRef());
        NetworkConfig networkConfig = config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        NetworkListeners nls = networkConfig.getNetworkListeners();
        Iterator<NetworkListener> listenerIter = nls.getNetworkListener().iterator();
        int i = 0;
        PropertyResolver resolver = new PropertyResolver(this._domain, this._server.getName());
        while (listenerIter.hasNext()) {
            String portVar;
            NetworkListener listener = listenerIter.next();
            NetworkListener rawListener = GlassFishConfigBean.getRawView(listener);
            String prot = rawListener.getProtocol();
            Protocol protocol = protocols.findProtocol(prot);
            if (rawListener.getName().equals(ADMIN_LISTENER)) continue;
            if (i > 0) {
                listenerStr.append(' ');
            }
            ++i;
            if (Boolean.valueOf(protocol.getSecurityEnabled()).booleanValue()) {
                listenerStr.append(HTTPS_PROTO);
            } else {
                listenerStr.append(HTTP_PROTO);
            }
            String hostName = this.getResolvedHostName(rawListener.getAddress());
            listenerStr.append(hostName);
            listenerStr.append(':');
            String port = rawListener.getPort();
            if (port != null && port.length() > 1 && port.charAt(0) == '$' && port.charAt(1) == '{' && port.charAt(port.length() - 1) == '}' && (port = resolver.getPropertyValue(portVar = port.substring(2, port.length() - 1))) == null) {
                throw new LbReaderException(LbLogUtil.getStringManager().getString("UnableToResolveSystemProperty", portVar, this._server.getName()));
            }
            listenerStr.append(port);
        }
        return listenerStr.toString();
    }

    public void accept(Visitor v) throws Exception {
        InstanceVisitor pv = (InstanceVisitor)v;
        pv.visit(this);
    }

    private String getResolvedHostName(String address) throws LbReaderException {
        InetAddress addr = null;
        if (!address.equals(BIND_TO_ANY)) {
            try {
                addr = InetAddress.getByName(address);
            }
            catch (UnknownHostException ex) {
                String msg = LbLogUtil.getStringManager().getString("CannotResolveHostName", address);
                throw new LbReaderException(msg, ex);
            }
            if (!addr.isLoopbackAddress()) {
                return address;
            }
        }
        String nodeName = this._server.getNodeRef();
        Node node = this._domain.getNodes().getNode(nodeName);
        if (node == null) {
            String msg = LbLogUtil.getStringManager().getString("UnableToGetNode", this._server.getName());
            throw new LbReaderException(msg);
        }
        if (node.getNodeHost() != null && !node.getNodeHost().equals(LOCALHOST)) {
            return node.getNodeHost();
        }
        return System.getProperty("com.sun.aas.hostName");
    }
}

