/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Service(name="list-jdbc-connection-pools")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@I18n(value="list.jdbc.connection.pools")
public class ListJdbcConnectionPools
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJdbcConnectionPools.class);
    @Inject
    private Domain domain;
    @Param(primary=true, optional=true, defaultValue="server", alias="targetName", obsolete=true)
    private String target;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Collection<JdbcConnectionPool> connPools = this.domain.getResources().getResources(JdbcConnectionPool.class);
            for (JdbcConnectionPool pool : connPools) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(pool.getName());
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.jdbc.connection.pools.failed", "List JDBC connection pools failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

