/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HealthHistory
implements ConfigListener {
    private static final Logger logger = LogDomains.getLogger(HealthHistory.class, "javax.enterprise.system.core");
    private static final StringManager strings = StringManager.getManager(HealthHistory.class);
    public static final long NOTIME = -1L;
    private final ConcurrentMap<String, InstanceHealth> healthMap = new ConcurrentHashMap<String, InstanceHealth>();
    private boolean keepFormerMembers = true;

    public HealthHistory(Cluster cluster) {
        for (Server server : cluster.getInstances()) {
            if (server.isDas()) continue;
            this.checkAndAddName(server.getName());
        }
    }

    public HealthHistory(String instanceName, boolean keepFormerMembers) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "KEEP_FORMER_MEMBER_HISTORY set to: " + keepFormerMembers);
        }
        this.checkAndAddName(instanceName);
        this.keepFormerMembers = keepFormerMembers;
    }

    private void checkAndAddName(String name) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("instance name in HealthHistory constructor %s", name));
        }
        if (this.healthMap.putIfAbsent(name, new InstanceHealth(STATE.NOT_RUNNING, -1L)) != null) {
            logger.log(Level.WARNING, "duplicate.instance", name);
        }
    }

    public InstanceHealth getHealthByInstance(String name) {
        return (InstanceHealth)this.healthMap.get(name);
    }

    public List<String> getInstancesByState(STATE targetState) {
        ArrayList<String> retVal = new ArrayList<String>(this.healthMap.size());
        for (String name : this.healthMap.keySet()) {
            if (((InstanceHealth)this.healthMap.get((Object)name)).state != targetState) continue;
            retVal.add(name);
        }
        return retVal;
    }

    public Set<String> getInstances() {
        return Collections.unmodifiableSet(this.healthMap.keySet());
    }

    public void updateHealth(Signal signal) {
        STATE state;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "signal: " + signal.toString());
        }
        String name = signal.getMemberToken();
        long time = signal.getStartTime();
        if (signal instanceof JoinNotificationSignal) {
            state = STATE.RUNNING;
        } else if (signal instanceof JoinedAndReadyNotificationSignal) {
            JoinedAndReadyNotificationSignal jar = (JoinedAndReadyNotificationSignal)signal;
            RejoinSubevent sub = jar.getRejoinSubevent();
            if (sub == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "it's a joined and ready");
                }
                state = STATE.RUNNING;
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "it's a rejoin");
                }
                state = STATE.REJOINED;
                time = sub.getGroupJoinTime();
            }
        } else if (signal instanceof FailureNotificationSignal) {
            if (this.keepFormerMembers) {
                state = STATE.FAILURE;
                time = System.currentTimeMillis();
            } else {
                state = null;
            }
        } else if (signal instanceof PlannedShutdownSignal) {
            if (this.keepFormerMembers) {
                state = STATE.SHUTDOWN;
                time = System.currentTimeMillis();
            } else {
                state = null;
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("Signal %s not handled in updateHealth", signal.toString()));
            }
            return;
        }
        if (state == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("Dropping health history for %s due to %s", name, signal.toString()));
            }
            this.deleteInstance(name);
            return;
        }
        InstanceHealth ih = new InstanceHealth(state, time);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.format("updating health with %s : %s for signal %s", name, ih.toString(), signal.toString()));
        }
        if (this.healthMap.put(name, ih) == null) {
            logger.log(Level.INFO, "unknown.instance", new Object[]{state, name});
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            ServerRef instance;
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (oldVal instanceof ServerRef && newVal == null) {
                instance = (ServerRef)oldVal;
                this.deleteInstance(instance.getRef());
                continue;
            }
            if (!(newVal instanceof ServerRef) || oldVal != null) continue;
            instance = (ServerRef)newVal;
            this.addInstance(instance.getRef());
        }
        return null;
    }

    private void deleteInstance(String name) {
        logger.log(Level.INFO, "deleting.instance", name);
        InstanceHealth oldHealth = (InstanceHealth)this.healthMap.remove(name);
        if (oldHealth == null) {
            logger.log(Level.WARNING, "delete.key.not.present", name);
        }
    }

    private void addInstance(String name) {
        logger.log(Level.INFO, "adding.instance", name);
        InstanceHealth oldHealth = this.healthMap.putIfAbsent(name, new InstanceHealth(STATE.NOT_RUNNING, -1L));
        if (oldHealth != null) {
            logger.log(Level.INFO, "key.already.present", name);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return strings;
    }

    public static final class InstanceHealth {
        public final STATE state;
        public final long time;

        InstanceHealth(STATE state, long time) {
            this.state = state;
            this.time = time;
        }

        public String toString() {
            return String.format("InstanceHealth: state '%s' time '%s'", new Object[]{this.state, new Date(this.time).toString()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        NOT_RUNNING(HealthHistory.access$000().getString("state.not_running")),
        RUNNING(HealthHistory.access$000().getString("state.running")),
        REJOINED(HealthHistory.access$000().getString("state.rejoined")),
        FAILURE(HealthHistory.access$000().getString("state.failure")),
        SHUTDOWN(HealthHistory.access$000().getString("state.shutdown"));

        private final String stringVal;

        private STATE(String stringVal) {
            this.stringVal = stringVal;
        }

        public String toString() {
            return this.stringVal;
        }
    }
}

