/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import com.sun.enterprise.util.ObjectAnalyzer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.api.monitoring.ProbeInfo;
import org.glassfish.api.monitoring.ProbeProviderInfo;
import org.glassfish.flashlight.provider.FlashlightProbe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashlightProbeProvider
implements ProbeProviderInfo {
    private boolean dtraceIsInstrumented;
    private final String moduleProviderName;
    private final String moduleName;
    private final String probeProviderName;
    private final Class providerClazz;
    private ConcurrentHashMap<String, FlashlightProbe> probes = new ConcurrentHashMap();
    private static final String CTOR_ERROR = "ProbeProviderInfo constructor -- you must supply valid arguments";

    public FlashlightProbeProvider(String moduleProviderName, String moduleName, String probeProviderName, Class providerClazz) {
        if (!(FlashlightProbeProvider.ok(moduleProviderName) && FlashlightProbeProvider.ok(moduleName) && FlashlightProbeProvider.ok(providerClazz))) {
            throw new RuntimeException(CTOR_ERROR);
        }
        this.moduleProviderName = moduleProviderName;
        this.moduleName = moduleName;
        this.providerClazz = providerClazz;
        this.probeProviderName = probeProviderName == null ? providerClazz.getName() : probeProviderName;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this);
    }

    @Override
    public Class getProviderClass() {
        return this.providerClazz;
    }

    @Override
    public String getModuleProviderName() {
        return this.moduleProviderName;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getProbeProviderName() {
        return this.probeProviderName;
    }

    public void addProbe(FlashlightProbe probe) {
        this.probes.put(probe.getProbeDesc(), probe);
    }

    public FlashlightProbe getProbe(String probeDescriptor) {
        return this.probes.get(probeDescriptor);
    }

    public Collection<FlashlightProbe> getProbes() {
        return this.probes.values();
    }

    @Override
    public ProbeInfo[] getProbesInfo() {
        Collection<FlashlightProbe> fprobes = this.getProbes();
        ProbeInfo[] infos = new ProbeInfo[fprobes.size()];
        int i = 0;
        for (FlashlightProbe fprobe : fprobes) {
            infos[i++] = fprobe;
        }
        return infos;
    }

    @Override
    public boolean isDTraceInstrumented() {
        return this.dtraceIsInstrumented;
    }

    @Override
    public void setDTraceInstrumented(boolean b) {
        this.dtraceIsInstrumented = b;
    }

    public boolean namesEqual(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FlashlightProbeProvider)) {
            return false;
        }
        FlashlightProbeProvider fpp = (FlashlightProbeProvider)o;
        return fpp.moduleName.equals(this.moduleName) && fpp.moduleProviderName.equals(this.moduleProviderName) && fpp.probeProviderName.equals(this.probeProviderName) && fpp.providerClazz == this.providerClazz;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static boolean ok(Class clazz) {
        return clazz != null;
    }
}

