/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.AnnotationScanner;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.Globals;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class GenericAnnotationDetector
extends AnnotationScanner {
    boolean found = false;
    List<String> annotations = new ArrayList<String>();
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");

    public GenericAnnotationDetector(Class[] annotationClasses) {
        if (annotationClasses != null) {
            for (Class annClass : annotationClasses) {
                this.annotations.add(Type.getDescriptor(annClass));
            }
        }
    }

    public boolean hasAnnotationInArchive(ReadableArchive archive) {
        this.scanArchive(archive);
        if (this.found) {
            return this.found;
        }
        ArchiveFactory archiveFactory = null;
        if (Globals.getDefaultHabitat() != null) {
            archiveFactory = Globals.getDefaultHabitat().getComponent(ArchiveFactory.class);
        }
        if (archiveFactory != null) {
            List<URI> externalLibs = DeploymentUtils.getExternalLibraries(archive);
            for (URI externalLib : externalLibs) {
                try {
                    this.scanArchive(archiveFactory.openArchive(new File(externalLib.getPath())));
                }
                catch (FileNotFoundException fnfe) {
                    logger.log(Level.WARNING, "Cannot find archive " + externalLib.getPath() + " referenced from archive " + archive.getName() + ", it will be ignored for annotation scanning");
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return this.found;
    }

    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        if (this.annotations.contains(s)) {
            this.found = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanArchive(ReadableArchive archive) {
        try {
            int crFlags = 7;
            Enumeration<String> entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement();
                if (entryName.endsWith(".class")) {
                    InputStream is = archive.getEntry(entryName);
                    try {
                        ClassReader cr = new ClassReader(is);
                        cr.accept(this, crFlags);
                        continue;
                    }
                    finally {
                        is.close();
                        continue;
                    }
                }
                if (!entryName.endsWith(".jar") || entryName.indexOf(47) != -1) continue;
                try {
                    ReadableArchive jarSubArchive = null;
                    try {
                        jarSubArchive = archive.getSubArchive(entryName);
                        Enumeration<String> jarEntries = jarSubArchive.entries();
                        while (jarEntries.hasMoreElements()) {
                            String jarEntryName = jarEntries.nextElement();
                            if (!jarEntryName.endsWith(".class")) continue;
                            InputStream is = jarSubArchive.getEntry(jarEntryName);
                            try {
                                ClassReader cr = new ClassReader(is);
                                cr.accept(this, crFlags);
                            }
                            finally {
                                is.close();
                            }
                        }
                    }
                    finally {
                        jarSubArchive.close();
                    }
                }
                catch (IOException ioe) {
                    logger.warning("Error scan jar entry" + entryName + ioe.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.warning("Failed to scan archive for annotations" + e.getMessage());
        }
    }
}

