/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUtils {
    public static final String DEPLOYMENT_PROPERTY_JAVA_WEB_START_ENABLED = "java-web-start-enabled";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentUtils.class);
    private static final Logger _logger = LogDomains.getLogger(DeploymentUtils.class, "javax.enterprise.system.tools.deployment");
    private static final String V2_COMPATIBILITY = "v2";
    private static final String WEB_INF = "WEB-INF";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String RESOURCES_XML_META_INF = "META-INF/glassfish-resources.xml";
    private static final String RESOURCES_XML_WEB_INF = "WEB-INF/glassfish-resources.xml";
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String SUN_APPLICATION_XML = "META-INF/sun-application.xml";
    private static final String GF_APPLICATION_XML = "META-INF/glassfish-application.xml";
    private static final String EAR_EXTENSION = ".ear";
    private static final String WAR_EXTENSION = ".war";
    private static final String RAR_EXTENSION = ".rar";
    private static final String EXPANDED_WAR_SUFFIX = "_war";
    private static final String EXPANDED_RAR_SUFFIX = "_rar";
    private static final String EXPANDED_JAR_SUFFIX = "_jar";
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    private static final String DAS_TARGET_NAME = "server";
    public static final String DOMAIN_TARGET_NAME = "domain";
    private static final String DOWNLOADABLE_ARTIFACTS_KEY_PREFIX = "downloadable";
    private static final String GENERATED_ARTIFACTS_KEY_PREFIX = "generated";

    public static boolean isDASTarget(String targetName) {
        return DAS_TARGET_NAME.equals(targetName);
    }

    public static boolean isDomainTarget(String targetName) {
        return DOMAIN_TARGET_NAME.equals(targetName);
    }

    public static long checksum(File directory) {
        if (!directory.isDirectory()) {
            String msg = localStrings.getLocalString("enterprise.deployment.remoteDirPathUnusable", "The directory deployment path {0} is not a directory or is inaccessible", directory.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        DeploymentUtils.scanDirectory(directory.toURI(), directory, uris);
        Collections.sort(uris);
        Adler32 checksum = new Adler32();
        for (URI uri : uris) {
            checksum.update(uri.toASCIIString().getBytes());
        }
        return checksum.getValue();
    }

    public static Artifacts downloadableArtifacts(DeploymentContext dc) {
        return Artifacts.get(dc, DOWNLOADABLE_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts downloadableArtifacts(Application app) {
        return Artifacts.get(app.getDeployProperties(), DOWNLOADABLE_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts generatedArtifacts(DeploymentContext dc) {
        return Artifacts.get(dc, GENERATED_ARTIFACTS_KEY_PREFIX);
    }

    public static Artifacts generatedArtifacts(Application app) {
        return Artifacts.get(app.getDeployProperties(), GENERATED_ARTIFACTS_KEY_PREFIX);
    }

    private static void scanDirectory(URI anchorDirURI, File directory, List<URI> uris) {
        for (File f : directory.listFiles()) {
            uris.add(anchorDirURI.relativize(f.toURI()));
            if (!f.isDirectory()) continue;
            DeploymentUtils.scanDirectory(anchorDirURI, f, uris);
        }
    }

    public static boolean isWebArchive(ReadableArchive archive) {
        try {
            if (Util.getURIName(archive.getURI()).endsWith(WAR_EXTENSION)) {
                return true;
            }
            if (archive.exists(WEB_INF)) {
                return true;
            }
            Enumeration<String> entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement();
                if (!entryName.endsWith(JSP_SUFFIX)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getDefaultEEName(String pathName) {
        if (pathName == null) {
            return null;
        }
        if ((pathName = pathName.replace('\\', '/')).endsWith("/")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        if (pathName.lastIndexOf("/") != -1) {
            pathName = pathName.substring(pathName.lastIndexOf("/") + 1);
        }
        if (pathName.endsWith(".jar") || pathName.endsWith(WAR_EXTENSION) || pathName.endsWith(RAR_EXTENSION) || pathName.endsWith(EAR_EXTENSION)) {
            return pathName.substring(0, pathName.length() - 4);
        }
        return pathName;
    }

    public static boolean hasResourcesXML(ReadableArchive archive) {
        boolean hasResourcesXML;
        block7: {
            hasResourcesXML = false;
            try {
                if (DeploymentUtils.isEAR(archive)) {
                    if (archive.exists(RESOURCES_XML_META_INF)) {
                        return true;
                    }
                    Enumeration<String> entries = archive.entries();
                    while (entries.hasMoreElements()) {
                        boolean answer;
                        String element = entries.nextElement();
                        if (!element.endsWith(".jar") && !element.endsWith(WAR_EXTENSION) && !element.endsWith(RAR_EXTENSION) && !element.endsWith(EXPANDED_JAR_SUFFIX) && !element.endsWith(EXPANDED_WAR_SUFFIX) && !element.endsWith(EXPANDED_RAR_SUFFIX)) continue;
                        ReadableArchive subArchive = archive.getSubArchive(element);
                        boolean bl = answer = subArchive != null && DeploymentUtils.hasResourcesXML(subArchive);
                        if (subArchive != null) {
                            subArchive.close();
                        }
                        if (!answer) continue;
                        return true;
                    }
                    break block7;
                }
                if (DeploymentUtils.isWebArchive(archive)) {
                    return archive.exists(RESOURCES_XML_WEB_INF);
                }
                return archive.exists(RESOURCES_XML_META_INF);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hasResourcesXML;
    }

    public static boolean isRAR(ReadableArchive archive) {
        boolean isRar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(RAR_EXTENSION)) {
                return true;
            }
            isRar = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isRar;
    }

    public static boolean isEAR(ReadableArchive archive) {
        boolean isEar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(EAR_EXTENSION)) {
                return true;
            }
            boolean bl = isEar = archive.exists(APPLICATION_XML) || archive.exists(SUN_APPLICATION_XML) || archive.exists(GF_APPLICATION_XML);
            if (!isEar) {
                isEar = DeploymentUtils.isEARFromIntrospecting(archive);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEar;
    }

    private static boolean isEARFromIntrospecting(ReadableArchive archive) throws IOException {
        for (String entryName : archive.getDirectories()) {
            if (!entryName.endsWith(EXPANDED_WAR_SUFFIX) && !entryName.endsWith(EXPANDED_RAR_SUFFIX) && !entryName.endsWith(EXPANDED_JAR_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory(new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName(moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilenameExtension(moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }

    public static boolean useV2Compatibility(DeploymentContext context) {
        return V2_COMPATIBILITY.equals(context.getAppProps().getProperty("compatibility"));
    }

    public static String relativizeWithinDomainIfPossible(URI absURI) throws URISyntaxException {
        URI instanceRootURI = new URI(System.getProperty(INSTANCE_ROOT_URI_PROPERTY_NAME));
        URI appURI = instanceRootURI.relativize(absURI);
        String appLocation = appURI.isAbsolute() ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
        return appLocation;
    }

    public static void validateApplicationName(String name) {
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", "/", name));
        }
        if (name.indexOf(35) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", "#", name));
        }
        if (name.indexOf(59) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", ";", name));
        }
    }

    public static String propertiesValue(Properties props, char sep) {
        StringBuilder sb = new StringBuilder();
        String currentSep = "";
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object v = props.get(key);
            sb.append(currentSep).append(key.toString()).append("=").append(v.toString());
            currentSep = String.valueOf(sep);
        }
        return sb.toString();
    }

    public static List<URL> getManifestLibraries(DeploymentContext context) throws IOException {
        return DeploymentUtils.getManifestLibraries(context.getSource());
    }

    public static List<URL> getManifestLibraries(DeploymentContext context, Manifest manifest) throws IOException {
        return DeploymentUtils.getManifestLibraries(context.getSource(), manifest);
    }

    public static List<URL> getManifestLibraries(ReadableArchive archive) throws IOException {
        return DeploymentUtils.getManifestLibraries(archive, archive.getManifest());
    }

    private static List<URL> getManifestLibraries(ReadableArchive archive, Manifest manifest) {
        String appRootPath = null;
        ReadableArchive parentArchive = archive.getParentArchive();
        if (parentArchive != null) {
            appRootPath = new File(parentArchive.getURI()).getPath();
        } else {
            try {
                appRootPath = new File(archive.getURI().getPath()).getParent();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ASClassLoaderUtil.getManifestClassPathAsURLs(manifest, appRootPath);
    }

    public static List<URI> getExternalLibraries(ReadableArchive archive) {
        ArrayList<URI> externalLibURIs = new ArrayList<URI>();
        try {
            List<URL> manifestURLs = DeploymentUtils.getManifestLibraries(archive);
            URI archiveURI = archive.getURI();
            if (archive.getParentArchive() != null) {
                archiveURI = archive.getParentArchive().getURI();
            }
            for (URL manifestURL : manifestURLs) {
                File externalLib;
                URI manifestLibURI = archiveURI.relativize(manifestURL.toURI());
                if (!manifestLibURI.isAbsolute() || !(externalLib = new File(manifestLibURI)).exists()) continue;
                externalLibURIs.add(manifestLibURI);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return externalLibURIs;
    }

    public static List<URL> getModuleLibraryJars(DeploymentContext context) throws Exception {
        ReadableArchive archive = context.getSource();
        List<URL> moduleLibraryURLs = new ArrayList<URL>();
        ArchiveHandler handler = context.getArchiveHandler();
        if (handler.getClass() == null || handler.getClass().getAnnotation(Service.class) == null) {
            return moduleLibraryURLs;
        }
        String handlerName = handler.getClass().getAnnotation(Service.class).name();
        File archiveFile = new File(archive.getURI());
        if (handlerName.equals("war")) {
            File webInf = new File(archiveFile, WEB_INF);
            File webInfLib = new File(webInf, "lib");
            if (webInfLib.exists()) {
                moduleLibraryURLs = DeploymentUtils.getLibDirectoryJars(webInfLib);
            }
        } else if (handlerName.equals("connector")) {
            moduleLibraryURLs = DeploymentUtils.getLibDirectoryJars(archiveFile);
        }
        return moduleLibraryURLs;
    }

    public static FileArchive openAsFileArchive(File dir, ArchiveFactory archiveFactory) throws IOException {
        return (FileArchive)archiveFactory.openArchive(dir);
    }

    private static List<URL> getLibDirectoryJars(File moduleLibDirectory) throws Exception {
        ArrayList<URL> libLibraryURLs = new ArrayList<URL>();
        File[] jarFiles = moduleLibDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".jar");
            }
        });
        if (jarFiles != null && jarFiles.length > 0) {
            for (File jarFile : jarFiles) {
                libLibraryURLs.add(jarFile.toURL());
            }
        }
        return libLibraryURLs;
    }
}

