/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.api.admin.ParameterMap;

@Produces(value={"text/html;qs=2", "application/json", "application/xml"})
public class TemplateCommandPostResource
extends TemplateExecCommand {
    public TemplateCommandPostResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        super(resourceName, commandName, commandMethod, commandAction, commandDisplayName, isLinkedToParent);
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response processPost(ParameterMap data) {
        if (data.containsKey("error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        this.processCommandParams(data);
        this.adjustParameters(data);
        this.purgeEmptyEntries(data);
        return super.executeCommand(data);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        return this.processPost(TemplateCommandPostResource.createDataBasedOnForm(formData));
    }

    @POST
    public Response processPost() {
        try {
            return this.processPost(new ParameterMap());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    public ActionReportResult get() {
        return this.options();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParameterMap createDataBasedOnForm(FormDataMultiPart formData) {
        ParameterMap data = new ParameterMap();
        try {
            Map<String, List<FormDataBodyPart>> m1 = formData.getFields();
            Set<String> ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() != null) {
                        InputStream fileStream = bodyPart.getValueAs(InputStream.class);
                        String mimeType = bodyPart.getMediaType().toString();
                        String fileName = bodyPart.getContentDisposition().getFileName();
                        if (fileName.contains("/")) {
                            fileName = Util.getName(fileName, '/');
                        } else if (fileName.contains("\\")) {
                            fileName = Util.getName(fileName, '\\');
                        }
                        File f = Util.saveFile(fileName, mimeType, fileStream);
                        f.deleteOnExit();
                        data.add(fieldName, f.getAbsolutePath());
                        continue;
                    }
                    data.add(fieldName, bodyPart.getValue());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateCommandPostResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            formData.cleanup();
        }
        return data;
    }
}

