/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.glassfish.admin.mbeanserver.ssl.SSLClientConfigurator;
import org.glassfish.admin.mbeanserver.ssl.SSLParams;

public final class SecureRMIClientSocketFactory
extends SslRMIClientSocketFactory {
    private transient InetAddress mAddress;
    private transient SSLParams sslParams;
    private volatile String[] enabledCipherSuites = null;
    private volatile String[] enabledProtocols = null;
    private transient Object cipherSuitesSync = new Object();
    private transient Object protocolsSync = new Object();
    private transient Map socketMap = new HashMap();
    private transient Logger _logger = Logger.getLogger(SecureRMIClientSocketFactory.class.getName());

    public SecureRMIClientSocketFactory(SSLParams sslParams, InetAddress addr) {
        this.mAddress = addr;
        this.sslParams = sslParams;
        if (sslParams != null) {
            this._logger.log(Level.INFO, "Creating a SecureRMIClientSocketFactory @ " + addr.getHostAddress() + "with ssl config = " + sslParams.toString());
        }
    }

    public SecureRMIClientSocketFactory() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecureRMIClientSocketFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public Socket createSocket(String host, int port) throws IOException {
        if (this.socketMap.containsKey(new Integer(port))) {
            return (Socket)this.socketMap.get(new Integer(port));
        }
        int backlog = 5;
        SSLClientConfigurator sslCC = SSLClientConfigurator.getInstance();
        this._logger.log(Level.INFO, "Setting SSLParams @ " + this.sslParams);
        sslCC.setSSLParams(this.sslParams);
        SSLContext sslContext = sslCC.configure(this.sslParams);
        SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(this.mAddress, port);
        this.configureSSLSocket(sslSocket, sslCC);
        this.socketMap.put(new Integer(8686), sslSocket);
        return sslSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSSLSocket(SSLSocket sslSocket, SSLClientConfigurator sslCC) {
        Object object;
        if (sslCC.getEnabledCipherSuites() != null) {
            if (this.enabledCipherSuites == null) {
                object = this.cipherSuitesSync;
                synchronized (object) {
                    if (this.enabledCipherSuites == null) {
                        this.enabledCipherSuites = SecureRMIClientSocketFactory.configureEnabledCiphers(sslSocket, sslCC.getEnabledCipherSuites());
                    }
                }
            }
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (sslCC.getEnabledProtocols() != null) {
            if (this.enabledProtocols == null) {
                object = this.protocolsSync;
                synchronized (object) {
                    if (this.enabledProtocols == null) {
                        this.enabledProtocols = SecureRMIClientSocketFactory.configureEnabledProtocols(sslSocket, sslCC.getEnabledProtocols());
                    }
                }
            }
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        sslSocket.setUseClientMode(true);
    }

    private static final String[] configureEnabledProtocols(SSLSocket socket, String[] requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLSocket socket, String[] requestedCiphers) {
        String[] supportedCiphers = socket.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }
}

