/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.stringifier;

import org.glassfish.admin.amx.util.stringifier.Stringifier;
import org.glassfish.admin.amx.util.stringifier.StringifierRegistry;
import org.glassfish.admin.amx.util.stringifier.StringifierRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfacesStringifier
implements Stringifier {
    private final StringifierRegistry mRegistry;
    private final Class<?>[] mInterfaces;

    public InterfacesStringifier(Class[] interfaces) {
        this(StringifierRegistryImpl.DEFAULT, interfaces);
    }

    public InterfacesStringifier(StringifierRegistry registry, Class[] interfaces) {
        this.mRegistry = registry;
        this.mInterfaces = interfaces;
    }

    private <T> String stringifyAs(Object o, Class<T> theClass) {
        Stringifier stringifier;
        String result = null;
        if (theClass.isAssignableFrom(o.getClass()) && (stringifier = this.mRegistry.lookup(theClass)) != null) {
            result = stringifier.stringify(o);
        }
        return result;
    }

    @Override
    public String stringify(Object o) {
        String result = "";
        for (int i = 0; i < this.mInterfaces.length; ++i) {
            Class<?> intf = this.mInterfaces[i];
            String s = this.stringifyAs(o, intf);
            if (s == null) continue;
            result = result + intf.getName() + ": " + s + "\n";
        }
        if (result == null || result.length() == 0) {
            result = o.toString();
        }
        return result;
    }
}

