/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import org.glassfish.admin.amx.util.ArrayConversion;
import org.glassfish.admin.amx.util.IteratorUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.CompositeTypeFromNameCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenMBeanUtil {
    private static Map<Class<?>, SimpleType> SIMPLETYPES_MAP = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final OpenType[] EMPTY_OPENTYPES = new OpenType[0];

    private OpenMBeanUtil() {
    }

    private static Map<Class<?>, SimpleType> getSimpleTypesMap() {
        if (SIMPLETYPES_MAP == null) {
            HashMap m = new HashMap();
            m.put(Byte.class, SimpleType.BYTE);
            m.put(Short.class, SimpleType.SHORT);
            m.put(Integer.class, SimpleType.INTEGER);
            m.put(Long.class, SimpleType.LONG);
            m.put(BigInteger.class, SimpleType.BIGINTEGER);
            m.put(BigDecimal.class, SimpleType.BIGDECIMAL);
            m.put(Float.class, SimpleType.FLOAT);
            m.put(Double.class, SimpleType.DOUBLE);
            m.put(Character.class, SimpleType.CHARACTER);
            m.put(Boolean.class, SimpleType.BOOLEAN);
            m.put(String.class, SimpleType.STRING);
            m.put(Date.class, SimpleType.DATE);
            m.put(Void.class, SimpleType.VOID);
            m.put(ObjectName.class, SimpleType.OBJECTNAME);
            SIMPLETYPES_MAP = m;
        }
        return SIMPLETYPES_MAP;
    }

    public static SimpleType getSimpleType(Class<?> c) {
        SimpleType type2 = OpenMBeanUtil.getSimpleTypesMap().get(c);
        return type2;
    }

    private static Object getAnyArrayElement(Object o) {
        Object result = null;
        int length = Array.getLength(o);
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(o, 0);
                if (element == null) continue;
                if (element.getClass().isArray()) {
                    result = OpenMBeanUtil.getAnyArrayElement(element);
                    if (result == null) continue;
                    break;
                }
                result = element;
                break;
            }
        }
        return result;
    }

    private static int getArrayDimensions(Class theClass) {
        String classname = theClass.getName();
        int dim = 0;
        while (classname.charAt(dim) == '[') {
            ++dim;
        }
        return dim;
    }

    public static ArrayType newArrayType(int numItems, OpenType type2) throws OpenDataException {
        return new ArrayType(numItems, type2);
    }

    public static OpenType getOpenType(Object o) throws InvalidOpenTypeException, OpenDataException {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        OpenType type2 = OpenMBeanUtil.getSimpleType(o.getClass());
        if (type2 == null) {
            Class<?> theClass = o.getClass();
            if (theClass.isArray()) {
                int length = Array.getLength(o);
                int dimensions = OpenMBeanUtil.getArrayDimensions(theClass);
                Class<?> elementClass = theClass.getComponentType();
                SimpleType simpleType = OpenMBeanUtil.getSimpleType(elementClass);
                if (simpleType != null) {
                    type2 = OpenMBeanUtil.newArrayType(dimensions, simpleType);
                } else {
                    Object element = OpenMBeanUtil.getAnyArrayElement(o);
                    if (CompositeData.class.isAssignableFrom(elementClass)) {
                        type2 = element == null ? SimpleType.VOID : OpenMBeanUtil.newArrayType(dimensions, ((CompositeData)element).getCompositeType());
                    } else if (TabularData.class.isAssignableFrom(elementClass)) {
                        type2 = element == null ? SimpleType.VOID : OpenMBeanUtil.newArrayType(dimensions, ((TabularData)TabularData.class.cast(element)).getTabularType());
                    }
                }
            } else if (o instanceof CompositeData) {
                type2 = ((CompositeData)o).getCompositeType();
            } else if (o instanceof TabularData) {
                type2 = ((TabularData)o).getTabularType();
            }
        }
        if (type2 == null) {
            throw new IllegalArgumentException(o.getClass().getName());
        }
        return type2;
    }

    public static Map<String, Serializable> convertTypes(Map<String, Serializable> orig) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (String key : orig.keySet()) {
            Serializable value = orig.get(key);
            if (value instanceof Collection) {
                Collection c = TypeCast.asCollection(value);
                Object[] newValue = IteratorUtil.toArray(c.iterator());
                newValue = ArrayConversion.specializeArray(newValue);
                result.put(key, (Serializable)newValue);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static CompositeType mapToCompositeType(String typeName, String description, Map<String, ?> map, CompositeTypeFromNameCallback callback) throws OpenDataException {
        String[] itemNames = new String[map.keySet().size()];
        map.keySet().toArray(itemNames);
        String[] itemDescriptions = new String[itemNames.length];
        OpenType[] itemTypes = new OpenType[itemNames.length];
        for (int i = 0; i < itemNames.length; ++i) {
            String name = itemNames[i];
            Object value = map.get(name);
            itemDescriptions[i] = "value " + name;
            itemTypes[i] = value == null ? callback.getOpenTypeFromName(name) : OpenMBeanUtil.getOpenType(value);
        }
        CompositeType type2 = new CompositeType(typeName, description, itemNames, itemDescriptions, itemTypes);
        return type2;
    }

    public static CompositeData mapToCompositeData(String typeName, String description, Map<String, Object> map) throws OpenDataException {
        CompositeType type2 = OpenMBeanUtil.mapToCompositeType(typeName, description, map, null);
        return new CompositeDataSupport(type2, map);
    }

    public static Map<String, Serializable> compositeDataToMap(CompositeData data) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        CompositeType type2 = data.getCompositeType();
        Set<String> keySet = TypeCast.asSet(type2.keySet());
        for (String name : keySet) {
            map.put(name, (Serializable)data.get(name));
        }
        return map;
    }

    public static OpenType getStackTraceElementOpenType() throws OpenDataException {
        String[] itemNames = new String[]{"ClassName", "FileName", "LineNumber", "IsNativeMethod"};
        String[] descriptions = new String[]{"ClassName", "FileName", "LineNumber", "IsNativeMethod"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = SimpleType.STRING;
        openTypes[2] = SimpleType.INTEGER;
        openTypes[3] = SimpleType.BOOLEAN;
        return new CompositeType(StackTraceElement.class.getName(), "StackTraceElement composite type", itemNames, descriptions, openTypes);
    }

    public static OpenType getThrowableOpenType(Throwable t) throws OpenDataException {
        String[] itemNames = new String[]{"Message", "Cause", "StackTrace"};
        String[] descriptions = new String[]{"The message from the Throwable", "The cause (if any) from the Throwable", "The stack trace from the Throwable"};
        OpenType[] openTypes = new OpenType[itemNames.length];
        openTypes[0] = SimpleType.STRING;
        openTypes[1] = t.getCause() == null ? SimpleType.VOID : OpenMBeanUtil.getThrowableOpenType(t.getCause());
        openTypes[2] = OpenMBeanUtil.newArrayType(t.getStackTrace().length, OpenMBeanUtil.getStackTraceElementOpenType());
        return new CompositeType(t.getClass().getName(), "Throwable composite type", itemNames, descriptions, openTypes);
    }
}

